/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration.page;

import java.util.Arrays;
import java.util.Optional;
import org.bonitasoft.web.designer.migration.AbstractMigrationStep;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;
import org.bonitasoft.web.designer.model.page.AbstractPage;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.model.page.PropertyValue;
import org.bonitasoft.web.designer.model.page.TabContainer;
import org.bonitasoft.web.designer.model.widget.BondType;
import org.bonitasoft.web.designer.visitor.AnyLocalContainerVisitor;
import org.bonitasoft.web.designer.visitor.ComponentVisitor;
import org.bonitasoft.web.designer.visitor.ElementVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetInterpretHtmlTrueMigrationStep<T extends AbstractPage>
extends AbstractMigrationStep<T> {
    private static final Logger logger = LoggerFactory.getLogger(SetInterpretHtmlTrueMigrationStep.class);
    private final ComponentVisitor componentVisitor;
    private static final String ALLOW_HTML_PROPERTY = "allowHTML";
    private static final String[] widgetWithAddedAllowHtml = new String[]{"pbAutocomplete", "pbButton", "pbCheckbox", "pbChecklist", "pbDatePicker", "pbDateTimePicker", "pbInput", "pbLink", "pbRadioButtons", "pbRichTextarea", "pbSaveButton", "pbSelect", "pbTextarea", "pbTitle", "pbUpload"};

    public SetInterpretHtmlTrueMigrationStep(ComponentVisitor componentVisitor) {
        this.componentVisitor = componentVisitor;
    }

    @Override
    public Optional<MigrationStepReport> migrate(AbstractPage page) {
        boolean pageChanged = false;
        for (Component component : (Iterable)page.accept((ElementVisitor)this.componentVisitor)) {
            if (!this.isAddedAllowHtmlProperty(component.getId())) continue;
            this.setAllowHtmlPropertyDefaultValue(component);
            pageChanged = true;
        }
        for (Element element : (Iterable)page.accept((ElementVisitor)new AnyLocalContainerVisitor())) {
            if (!(element instanceof TabContainer)) continue;
            this.setAllowHtmlPropertyDefaultValue((Component)((TabContainer)element));
            pageChanged = true;
        }
        if (pageChanged) {
            String message = String.format("'Interpret HTML' property has been added in some widgets for page %s. Now, you can disable it if you don't need it. If you keep it enabled, this could potentially lead to HTML injections attacks. Please take into account these risks.", page.getName());
            logger.info("[MIGRATION] {}", (Object)message);
            return Optional.of(MigrationStepReport.warningMigrationReport((String)page.getName(), (String)message, (String)this.getClass().getName()));
        }
        return Optional.empty();
    }

    @Override
    public String getErrorMessage() {
        return "An error occurred during set allowHtml property migration";
    }

    private void setAllowHtmlPropertyDefaultValue(Component component) {
        if (!component.getPropertyValues().containsKey(ALLOW_HTML_PROPERTY)) {
            PropertyValue propertyValue = new PropertyValue();
            propertyValue.setType(BondType.CONSTANT.toJson());
            propertyValue.setValue((Object)true);
            component.getPropertyValues().put(ALLOW_HTML_PROPERTY, propertyValue);
        }
    }

    private boolean isAddedAllowHtmlProperty(String componentId) {
        return Arrays.asList(widgetWithAddedAllowHtml).contains(componentId);
    }
}

