/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bonitasoft.web.designer.common.repository.PageRepository;
import org.bonitasoft.web.designer.common.repository.exception.NotFoundException;
import org.bonitasoft.web.designer.common.visitor.AssetVisitor;
import org.bonitasoft.web.designer.config.UiDesignerProperties;
import org.bonitasoft.web.designer.controller.asset.AssetService;
import org.bonitasoft.web.designer.controller.asset.PageAssetPredicate;
import org.bonitasoft.web.designer.model.ArtifactStatusReport;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.migrationReport.MigrationResult;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStatus;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.model.page.WebResource;
import org.bonitasoft.web.designer.service.AbstractAssetableArtifactService;
import org.bonitasoft.web.designer.service.PageMigrationApplyer;
import org.bonitasoft.web.designer.service.PageService;
import org.bonitasoft.web.designer.service.exception.IncompatibleException;
import org.bonitasoft.web.designer.visitor.ComponentVisitor;
import org.bonitasoft.web.designer.visitor.WebResourcesVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DefaultPageService
extends AbstractAssetableArtifactService<PageRepository, Page>
implements PageService {
    private static final Logger log = LoggerFactory.getLogger(DefaultPageService.class);
    private final PageMigrationApplyer pageMigrationApplyer;
    private final ComponentVisitor componentVisitor;
    private final AssetVisitor assetVisitor;
    private final WebResourcesVisitor webResourcesVisitor;

    public DefaultPageService(PageRepository pageRepository, PageMigrationApplyer pageMigrationApplyer, ComponentVisitor componentVisitor, AssetVisitor assetVisitor, UiDesignerProperties uiDesignerProperties, AssetService<Page> pageAssetService, WebResourcesVisitor webResourcesVisitor) {
        super(uiDesignerProperties, pageAssetService, pageRepository);
        this.pageMigrationApplyer = pageMigrationApplyer;
        this.componentVisitor = componentVisitor;
        this.assetVisitor = assetVisitor;
        this.webResourcesVisitor = webResourcesVisitor;
    }

    @Override
    public Page get(String id) {
        Page page = (Page)((PageRepository)this.repository).get(id);
        return this.migrate(page);
    }

    @Override
    public Page getWithAsset(String id) {
        Page page = (Page)((PageRepository)this.repository).get(id);
        page = this.migrate(page);
        page.setAssets(this.assetVisitor.visit((Previewable)page));
        return page;
    }

    @Override
    public List<Page> getAll() {
        return ((PageRepository)this.repository).getAll().stream().map(page -> {
            page.setStatus(this.getStatus((Page)page));
            return page;
        }).collect(Collectors.toList());
    }

    @Override
    public Page create(Page page) {
        Page savedPage = this.doCreate(page);
        this.assetService.loadDefaultAssets(page);
        return savedPage;
    }

    @Override
    public Page createFrom(String sourcePageId, Page page) {
        Page savedPage = this.doCreate(page);
        this.assetService.duplicateAsset(((PageRepository)this.repository).resolvePath(sourcePageId), ((PageRepository)this.repository).resolvePath(sourcePageId), sourcePageId, savedPage.getId());
        return savedPage;
    }

    private Page doCreate(Page page) {
        String pageId = ((PageRepository)this.repository).getNextAvailableId(page.getName());
        page.setId(pageId);
        page.setUUID(UUID.randomUUID().toString());
        page.setAssets(page.getAssets().stream().filter(new PageAssetPredicate()).collect(Collectors.toSet()));
        return (Page)((PageRepository)this.repository).updateLastUpdateAndSave((Identifiable)page);
    }

    @Override
    public Page save(String pageId, Page page) {
        try {
            Page existingPage = this.get(pageId);
            if (!existingPage.isCompatible()) {
                throw new IncompatibleException("Page " + existingPage.getId() + " is in an incompatible version. Newer UI Designer version is required.");
            }
            if (existingPage.getName().equals(page.getName())) {
                page.setId(existingPage.getId());
            } else {
                page.setId(((PageRepository)this.repository).getNextAvailableId(page.getName()));
            }
        }
        catch (NotFoundException e) {
            page.setId(((PageRepository)this.repository).getNextAvailableId(page.getName()));
        }
        if (!StringUtils.hasText((String)page.getUUID())) {
            page.setUUID(UUID.randomUUID().toString());
        }
        page.setAssets(page.getAssets().stream().filter(new PageAssetPredicate()).collect(Collectors.toSet()));
        Page savedPage = (Page)((PageRepository)this.repository).updateLastUpdateAndSave((Identifiable)page);
        if (!savedPage.getId().equals(pageId)) {
            this.assetService.duplicateAsset(((PageRepository)this.repository).resolvePath(pageId), ((PageRepository)this.repository).resolvePath(pageId), pageId, savedPage.getId());
            ((PageRepository)this.repository).delete(pageId);
        }
        return savedPage;
    }

    @Override
    public Page rename(String pageId, String name) {
        Page page = this.get(pageId);
        if (!page.getName().equals(name)) {
            String newPageId = ((PageRepository)this.repository).getNextAvailableId(name);
            page.setId(newPageId);
            page.setName(name);
            Page savedPage = (Page)((PageRepository)this.repository).updateLastUpdateAndSave((Identifiable)page);
            this.assetService.duplicateAsset(((PageRepository)this.repository).resolvePath(pageId), ((PageRepository)this.repository).resolvePath(pageId), pageId, savedPage.getId());
            ((PageRepository)this.repository).delete(pageId);
            return savedPage;
        }
        return page;
    }

    @Override
    public void delete(String pageId) {
        ((PageRepository)this.repository).delete(pageId);
    }

    @Override
    public List<WebResource> detectAutoWebResources(Page page) {
        Object resources = this.webResourcesVisitor.visit((Previewable)page);
        return resources.values().stream().collect(Collectors.toList());
    }

    @Override
    public List<String> getResources(Page page) {
        List<WebResource> autoResource = this.detectAutoWebResources(page);
        List resources = autoResource.stream().map(WebResource::toDefinition).collect(Collectors.toList());
        List manual = page.getWebResources().stream().map(WebResource::toDefinition).collect(Collectors.toList());
        resources.addAll(manual);
        ArrayList componentList = new ArrayList();
        this.componentVisitor.visit((Previewable)page).forEach(componentList::add);
        return resources.stream().distinct().collect(Collectors.toList());
    }

    @Override
    public Page migrate(Page page) {
        MigrationResult<Page> migrationResult = this.migrateWithReport(page);
        return (Page)migrationResult.getArtifact();
    }

    @Override
    public MigrationResult<Page> migrateWithReport(Page pageToMigrate) {
        pageToMigrate.setStatus(this.getStatus(pageToMigrate));
        if (!pageToMigrate.getStatus().isMigration()) {
            return new MigrationResult((Object)pageToMigrate, Collections.emptyList());
        }
        MigrationResult<Page> migratedResult = this.pageMigrationApplyer.migrate(pageToMigrate);
        Page migratedPage = (Page)migratedResult.getArtifact();
        if (!migratedResult.getFinalStatus().equals((Object)MigrationStatus.ERROR)) {
            ((PageRepository)this.repository).updateLastUpdateAndSave((Identifiable)migratedPage);
        } else {
            migratedResult.getMigrationStepReportList().stream().filter(report -> !MigrationStatus.SUCCESS.equals((Object)report.getMigrationStatus())).forEach(report -> log.error("{}: {} - {}", new Object[]{report.getMigrationStatus(), report.getStepInfo(), report.getComments()}));
        }
        return migratedResult;
    }

    @Override
    public ArtifactStatusReport getStatus(Page page) {
        ArtifactStatusReport pageStatusReport = super.getStatus(page);
        ArtifactStatusReport depReport = this.pageMigrationApplyer.getPageStatusDependencies(page);
        return this.mergeStatusReport(pageStatusReport, depReport);
    }

    @Override
    public Set<Asset> listAsset(Page page) {
        return this.assetVisitor.visit((Previewable)page);
    }
}

