/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.service;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.bonitasoft.web.designer.migration.Migration;
import org.bonitasoft.web.designer.model.ArtifactStatusReport;
import org.bonitasoft.web.designer.model.migrationReport.MigrationResult;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.service.FragmentService;
import org.bonitasoft.web.designer.service.WidgetService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageMigrationApplyer {
    private static final Logger log = LoggerFactory.getLogger(PageMigrationApplyer.class);
    private final List<Migration<Page>> migrationList;
    private final FragmentService fragmentService;
    private final WidgetService widgetService;

    public PageMigrationApplyer(List<Migration<Page>> pageMigrationStepsList, WidgetService widgetService, FragmentService fragmentService) {
        this.widgetService = widgetService;
        this.migrationList = pageMigrationStepsList;
        this.fragmentService = fragmentService;
    }

    public MigrationResult<Page> migrate(Page page) {
        Instant startTime = Instant.now();
        String formerArtifactVersion = page.getArtifactVersion();
        ArrayList<MigrationStepReport> reports = new ArrayList<MigrationStepReport>();
        for (Migration<Page> migration : this.migrationList) {
            reports.addAll(migration.migrate(page));
        }
        reports.addAll(this.migrateAllWidgetUsed(page));
        reports.addAll(this.migrateAllFragmentUsed(page));
        this.updatePreviousArtifactVersionIfMigrationDone(page, formerArtifactVersion, startTime);
        return new MigrationResult((Object)page, reports);
    }

    public ArtifactStatusReport getPageStatusDependencies(Page page) {
        ArtifactStatusReport widgetStatus = this.widgetService.getArtifactStatusOfCustomWidgetUsed((Previewable)page);
        ArtifactStatusReport fragmentStatus = this.fragmentService.getArtifactStatusOfFragmentUsed((Previewable)page);
        if (!widgetStatus.isCompatible() || !fragmentStatus.isCompatible()) {
            return new ArtifactStatusReport(false, false);
        }
        if (widgetStatus.isMigration() || fragmentStatus.isMigration()) {
            return new ArtifactStatusReport();
        }
        return new ArtifactStatusReport(true, false);
    }

    protected void updatePreviousArtifactVersionIfMigrationDone(Page page, String formerArtifactVersion, Instant startTime) {
        if (!StringUtils.equals((CharSequence)formerArtifactVersion, (CharSequence)page.getArtifactVersion())) {
            page.setPreviousArtifactVersion(formerArtifactVersion);
            float durationTime = (float)Duration.between(startTime, Instant.now()).toMillis() / 1000.0f;
            log.info("[MIGRATION] Page {} has been terminated in {} seconds!", (Object)page.getName(), (Object)Float.valueOf(durationTime));
        }
    }

    protected List<MigrationStepReport> migrateAllWidgetUsed(Page page) {
        return this.widgetService.migrateAllCustomWidgetUsedInPreviewable((Previewable)page);
    }

    private List<MigrationStepReport> migrateAllFragmentUsed(Page page) {
        return this.fragmentService.migrateAllFragmentUsed((Previewable)page);
    }
}

