/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.workspace;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.bonitasoft.web.angularjs.rendering.WidgetFileHelper;
import org.bonitasoft.web.designer.ArtifactBuilderException;
import org.bonitasoft.web.designer.common.GeneratorStrategy;
import org.bonitasoft.web.designer.common.migration.Version;
import org.bonitasoft.web.designer.common.repository.PageRepository;
import org.bonitasoft.web.designer.common.repository.WidgetFileBasedLoader;
import org.bonitasoft.web.designer.common.repository.WidgetRepository;
import org.bonitasoft.web.designer.config.DesignerInitializerException;
import org.bonitasoft.web.designer.config.UiDesignerProperties;
import org.bonitasoft.web.designer.controller.importer.dependencies.AssetDependencyImporter;
import org.bonitasoft.web.designer.migration.LiveRepositoryUpdate;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.JsonHandler;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.workspace.ResourcesCopier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.FileSystemUtils;

public class Workspace {
    private static final Logger log = LoggerFactory.getLogger(Workspace.class);
    public static final String EXTRACT_BACKEND_RESOURCES = "META-INF/resources";
    public static final String WIDGETS_RESOURCES = "widgets";
    public static final String METADATA_FOLDER_NAME = ".metadata";
    protected static final Logger logger = LoggerFactory.getLogger(Workspace.class);
    private final UiDesignerProperties uiDesignerProperties;
    private final WidgetRepository widgetRepository;
    private final PageRepository pageRepository;
    private final GeneratorStrategy generatorStrategy;
    private final ResourcesCopier resourcesCopier;
    private final AssetDependencyImporter<Widget> widgetAssetDependencyImporter;
    private final Path extractPath;
    private final List<LiveRepositoryUpdate> migrations;
    private final JsonHandler jsonHandler;
    protected AtomicBoolean initialized = new AtomicBoolean(false);

    public Workspace(UiDesignerProperties uiDesignerProperties, WidgetRepository widgetRepository, PageRepository pageRepository, GeneratorStrategy generatorStrategy, AssetDependencyImporter<Widget> widgetAssetDependencyImporter, ResourcesCopier resourcesCopier, List<LiveRepositoryUpdate> migrations, JsonHandler jsonHandler) {
        this.widgetRepository = widgetRepository;
        this.pageRepository = pageRepository;
        this.generatorStrategy = generatorStrategy;
        this.resourcesCopier = resourcesCopier;
        this.widgetAssetDependencyImporter = widgetAssetDependencyImporter;
        this.uiDesignerProperties = uiDesignerProperties;
        this.extractPath = generatorStrategy.getGeneratorProperties().getExtractPath();
        this.migrations = migrations;
        this.jsonHandler = jsonHandler;
    }

    protected void doInitialize() throws IOException {
        FileSystemUtils.deleteRecursively((Path)this.extractPath);
        this.ensureTemplateRepositoryPresent();
        this.ensureTemplateRepositoryFilled();
        this.ensurePageRepositoryPresent();
        this.ensureWidgetRepositoryPresent();
        this.ensureWidgetRepositoryFilled();
        this.ensureFragmentRepositoryPresent();
        this.cleanFragmentWorkspace();
        this.extractResourcesForExport();
    }

    public void initialize() {
        if (!this.initialized.get()) {
            try {
                this.doInitialize();
                for (LiveRepositoryUpdate migration : this.migrations) {
                    migration.start();
                }
                this.cleanPageWorkspace();
                this.initialized.set(true);
            }
            catch (IOException e) {
                throw new DesignerInitializerException("Unable to initialize workspace", e);
            }
        }
    }

    public void migrateWorkspace() {
        this.initialize();
        this.migrations.stream().forEachOrdered(migration -> {
            try {
                migration.migrate();
            }
            catch (IOException e) {
                throw new DesignerInitializerException("Unable to migrate workspace", e);
            }
        });
    }

    public void indexingArtifacts(List<Page> pages) {
        this.initialize();
        this.pageRepository.refreshIndexing(pages);
    }

    public void cleanPageWorkspace() {
        Path pageWorkspace = this.uiDesignerProperties.getWorkspace().getPages().getDir();
        String[] files = Objects.requireNonNull(pageWorkspace.toFile().list());
        Arrays.stream(files).forEach(pageFolder -> {
            if (METADATA_FOLDER_NAME.equals(pageFolder)) {
                this.cleanMetadataFolder(pageWorkspace);
                return;
            }
            try {
                if (this.isPageExist(pageWorkspace, (String)pageFolder)) {
                    FileUtils.deleteDirectory((File)pageWorkspace.resolve((String)pageFolder).resolve("js").toFile());
                } else {
                    File f = pageWorkspace.resolve((String)pageFolder).toFile();
                    if (f.isDirectory()) {
                        FileUtils.deleteDirectory((File)pageWorkspace.resolve((String)pageFolder).toFile());
                        logger.debug("Deleting folder [{}] with success", (Object)pageWorkspace.resolve((String)pageFolder));
                    }
                }
            }
            catch (IOException e) {
                logger.error("Technical error when deleting files [{}]", (Object)pageWorkspace.resolve((String)pageFolder).resolve("js"), (Object)e);
            }
        });
    }

    protected void cleanMetadataFolder(Path workspace) {
        File metadataFolder = new File(workspace.resolve(METADATA_FOLDER_NAME).toString());
        Arrays.stream(Objects.requireNonNull(metadataFolder.listFiles())).forEach(page -> {
            String pageFileName = page.getName();
            if (!this.pageExists(workspace, pageFileName)) {
                this.deleteMissingPageMetadata(workspace, pageFileName);
            }
        });
    }

    private void deleteMissingPageMetadata(Path workspace, String pageFileName) {
        try {
            Files.delete(workspace.resolve(METADATA_FOLDER_NAME).resolve(pageFileName));
        }
        catch (IOException e) {
            logger.error("Technical error when deleting file [{}]", (Object)workspace.resolve(METADATA_FOLDER_NAME).resolve("js"));
        }
    }

    private boolean pageExists(Path workspace, String fileName) {
        return workspace.resolve(this.removeExtension(fileName)).resolve(fileName).toFile().exists();
    }

    private String removeExtension(String fileName) {
        if (fileName.indexOf(".") != -1) {
            return fileName.substring(0, fileName.lastIndexOf("."));
        }
        return fileName;
    }

    private boolean isPageExist(Path pageWorkspace, String pageFolder) {
        return pageWorkspace.resolve(pageFolder).resolve(pageFolder + ".json").toFile().exists();
    }

    private void ensureTemplateRepositoryPresent() throws IOException {
        Files.createDirectories(this.extractPath.resolve("templates"), new FileAttribute[0]);
    }

    private void ensureTemplateRepositoryFilled() throws IOException {
        this.resourcesCopier.copy(this.extractPath, "templates");
    }

    private void ensurePageRepositoryPresent() throws IOException {
        Files.createDirectories(this.uiDesignerProperties.getWorkspace().getPages().getDir(), new FileAttribute[0]);
    }

    private void ensureWidgetRepositoryPresent() throws IOException {
        Files.createDirectories(this.uiDesignerProperties.getWorkspace().getWidgets().getDir(), new FileAttribute[0]);
    }

    private void ensureWidgetRepositoryFilled() throws IOException {
        this.resourcesCopier.copy(this.extractPath, WIDGETS_RESOURCES);
        Path widgetRepositorySourcePath = this.extractPath.resolve(WIDGETS_RESOURCES);
        WidgetFileBasedLoader widgetLoader = new WidgetFileBasedLoader(this.jsonHandler);
        List widgets = widgetLoader.getAll(widgetRepositorySourcePath);
        for (Widget widget : widgets) {
            if (!this.widgetRepository.exists(widget.getId())) {
                this.createWidget(widgetRepositorySourcePath, widget);
                continue;
            }
            Widget repoWidget = (Widget)this.widgetRepository.get(widget.getId());
            if (!StringUtils.isBlank((CharSequence)repoWidget.getArtifactVersion()) && !new Version(this.uiDesignerProperties.getModelVersion()).isGreaterThan(repoWidget.getArtifactVersion())) continue;
            FileUtils.deleteDirectory((File)this.widgetRepository.resolvePath(widget.getId()).toFile());
            this.createWidget(widgetRepositorySourcePath, widget);
        }
        this.generatorStrategy.widgetFileBuilder().start(this.uiDesignerProperties.getWorkspace().getWidgets().getDir());
    }

    private void createWidget(Path widgetRepositorySourcePath, Widget widget) throws IOException {
        Path targetWidgetPath = this.widgetRepository.resolvePath(widget.getId());
        Path widgetRepositoryPath = Files.createDirectories(targetWidgetPath, new FileAttribute[0]);
        this.widgetRepository.updateLastUpdateAndSave((Identifiable)widget);
        File sourceHelpFile = new File(widgetRepositorySourcePath.toString() + File.separator + widget.getId() + File.separator + "help.html");
        if (widget.hasHelp() && sourceHelpFile.exists()) {
            FileUtils.copyFile((File)sourceHelpFile, (File)new File(widgetRepositoryPath.toString() + File.separator + "help.html"));
        }
        try {
            List<Asset> assets = this.widgetAssetDependencyImporter.load((Identifiable)widget, widgetRepositorySourcePath);
            this.widgetAssetDependencyImporter.save(assets, widgetRepositorySourcePath);
        }
        catch (IOException e) {
            String error = String.format("Technical error when importing widget asset [%s]", widget.getId());
            logger.error(error, (Throwable)e);
            throw new ArtifactBuilderException(error, e);
        }
    }

    private void cleanFragmentWorkspace() {
        Path fragWorkspace = this.uiDesignerProperties.getWorkspace().getFragments().getDir();
        Arrays.stream(Objects.requireNonNull(fragWorkspace.toFile().list())).forEach(fragment -> {
            if (METADATA_FOLDER_NAME.equals(fragment)) {
                this.cleanMetadataFolder(fragWorkspace);
                return;
            }
            try {
                if (this.isFragmentDescriptorExist(fragWorkspace, (String)fragment)) {
                    WidgetFileHelper.deleteConcatenateFile((Path)fragWorkspace.resolve((String)fragment));
                } else {
                    File f = fragWorkspace.resolve((String)fragment).toFile();
                    if (f.isDirectory()) {
                        FileUtils.deleteDirectory((File)fragWorkspace.resolve((String)fragment).toFile());
                    }
                    logger.debug("Deleted fragment folder [{}] with success", (Object)fragWorkspace.resolve((String)fragment));
                }
            }
            catch (IOException e) {
                String error = "Error while filter file in folder " + fragWorkspace.resolve((String)fragment).resolve((String)fragment);
                logger.error(error, (Throwable)e);
            }
        });
    }

    private void ensureFragmentRepositoryPresent() throws IOException {
        Path fragmentsPath = this.uiDesignerProperties.getWorkspace().getFragments().getDir();
        Files.createDirectories(fragmentsPath, new FileAttribute[0]);
        this.generatorStrategy.fragmentDirectiveBuilder().start(fragmentsPath);
    }

    private boolean isFragmentDescriptorExist(Path fragWorkspace, String fragment) {
        return fragWorkspace.resolve(fragment).resolve(fragment + ".json").toFile().exists();
    }

    private void extractResourcesForExport() throws IOException {
        this.resourcesCopier.copy(this.extractPath, EXTRACT_BACKEND_RESOURCES);
    }
}

