/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.export.properties;

import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.controller.export.properties.BonitaVariableResourcePredicate;
import org.bonitasoft.web.designer.model.data.DataType;
import org.bonitasoft.web.designer.model.data.Variable;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class BonitaVariableResourcePredicateTest {
    private Variable variable;
    private BonitaVariableResourcePredicate predicate;

    BonitaVariableResourcePredicateTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.variable = new Variable(DataType.URL, "");
        this.predicate = new BonitaVariableResourcePredicate("matches");
    }

    @Test
    void should_return_true_if_match_regex() throws Exception {
        this.variable.setType(DataType.URL);
        this.variable.setDisplayValue("matches");
        Assertions.assertThat((boolean)this.predicate.test(this.variable)).isTrue();
    }

    @Test
    void should_not_accept_url_not_accessing_bonita_api() throws Exception {
        this.variable.setType(DataType.URL);
        this.variable.setDisplayValue("do not match");
        Assertions.assertThat((boolean)this.predicate.test(this.variable)).isFalse();
    }

    @Test
    void should_not_accept_a_constant_data() throws Exception {
        this.variable.setType(DataType.CONSTANT);
        this.variable.setDisplayValue("matches");
        Assertions.assertThat((boolean)this.predicate.test(this.variable)).isFalse();
    }

    @Test
    void should_not_accept_an_expression_data() throws Exception {
        this.variable.setType(DataType.EXPRESSION);
        this.variable.setDisplayValue("matches");
        Assertions.assertThat((boolean)this.predicate.test(this.variable)).isFalse();
    }

    @Test
    void should_not_accept_a_JSON_data() throws Exception {
        this.variable.setType(DataType.JSON);
        this.variable.setDisplayValue("matches");
        Assertions.assertThat((boolean)this.predicate.test(this.variable)).isFalse();
    }
}

