/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration.page;

import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.migration.page.PageUUIDMigrationStep;
import org.bonitasoft.web.designer.model.page.Page;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class PageUUIDMigrationStepTest {
    PageUUIDMigrationStep pageUUIDMigrationStep;

    PageUUIDMigrationStepTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.pageUUIDMigrationStep = new PageUUIDMigrationStep();
    }

    @Test
    void should_migrate_page_with_UUID_like_id() throws Exception {
        Page pageWithoutUUID = PageBuilder.aPage().withId(UUID.randomUUID().toString()).withUUID(null).build();
        this.pageUUIDMigrationStep.migrate(pageWithoutUUID);
        Assertions.assertThat((String)pageWithoutUUID.getUUID()).isEqualTo(pageWithoutUUID.getId());
    }

    @Test
    void should_migrate_page_generating_a_UUID() throws Exception {
        Page pageWithoutUUID = PageBuilder.aPage().withId("maPage").withUUID(null).build();
        this.pageUUIDMigrationStep.migrate(pageWithoutUUID);
        Assertions.assertThat((String)pageWithoutUUID.getUUID()).isNotNull();
    }

    @Test
    void should_not_migrate_a_page_with_already_a_uuid() throws Exception {
        String uuid = UUID.randomUUID().toString();
        Page pageWithUUID = PageBuilder.aPage().withId("maPage").withUUID(uuid).build();
        this.pageUUIDMigrationStep.migrate(pageWithUUID);
        Assertions.assertThat((String)pageWithUUID.getUUID()).isEqualTo(uuid);
    }
}

