/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.config;

import java.nio.file.Path;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="designer.workspace-uid")
public class WorkspaceUidProperties {
    public static final String FRAGMENTS = "fragments";
    private static final String PAGES_DEFAULT_DIRECTORY = "pages";
    private boolean liveBuildEnabled = true;
    private Path path = Path.of(System.getProperty("java.io.tmpdir"), new String[0]).resolve("workspace-uid");

    public Path getTmpFragmentsRepositoryPath() {
        return this.getPath().resolve(FRAGMENTS);
    }

    public Path getTmpPagesRepositoryPath() {
        return this.getPath().resolve(PAGES_DEFAULT_DIRECTORY);
    }

    public Path getExtractPath() {
        return this.path.resolve("extract");
    }

    public boolean isLiveBuildEnabled() {
        return this.liveBuildEnabled;
    }

    public Path getPath() {
        return this.path;
    }

    public void setLiveBuildEnabled(boolean liveBuildEnabled) {
        this.liveBuildEnabled = liveBuildEnabled;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorkspaceUidProperties)) {
            return false;
        }
        WorkspaceUidProperties other = (WorkspaceUidProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isLiveBuildEnabled() != other.isLiveBuildEnabled()) {
            return false;
        }
        Path this$path = this.getPath();
        Path other$path = other.getPath();
        return !(this$path == null ? other$path != null : !((Object)this$path).equals(other$path));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorkspaceUidProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isLiveBuildEnabled() ? 79 : 97);
        Path $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
        return result;
    }

    public String toString() {
        return "WorkspaceUidProperties(liveBuildEnabled=" + this.isLiveBuildEnabled() + ", path=" + this.getPath() + ")";
    }
}

