/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller;

import java.beans.PropertyDescriptor;
import java.util.Objects;
import java.util.function.Predicate;
import org.springframework.beans.BeanUtils;

public class Predicates {
    private Predicates() {
    }

    public static <T> Predicate<T> propertyEqualTo(String propertyName, Object propertyValue) {
        return object -> {
            try {
                PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor(object.getClass(), (String)propertyName);
                return propertyDescriptor != null && Objects.equals(propertyValue, propertyDescriptor.getReadMethod().invoke(object, new Object[0]));
            }
            catch (ReflectiveOperationException e) {
                return false;
            }
        };
    }
}

