/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.importer.report;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bonitasoft.web.designer.controller.importer.dependencies.ComponentDependencyImporter;
import org.bonitasoft.web.designer.controller.importer.dependencies.DependencyImporter;
import org.bonitasoft.web.designer.model.Identifiable;

public class Dependencies {
    private Map<String, List<Object>> added;
    private Map<String, List<Object>> overwritten;

    public static Dependencies from(Map<DependencyImporter, List<?>> dependenciesAsList) {
        Dependencies dependencies = new Dependencies();
        for (Map.Entry<DependencyImporter, List<?>> entry : dependenciesAsList.entrySet()) {
            DependencyImporter dependencyImporter = entry.getKey();
            if (!(dependencyImporter instanceof ComponentDependencyImporter)) continue;
            dependencies.add(entry.getValue(), (ComponentDependencyImporter)dependencyImporter);
        }
        return dependencies;
    }

    private void add(List<Identifiable> identifiables, ComponentDependencyImporter<Identifiable> importer) {
        for (Identifiable identifiable : identifiables) {
            if (importer.exists(identifiable)) {
                this.addOverwrittenDependency(importer.getComponentName(), importer.getOriginalElementFromRepository(identifiable));
                continue;
            }
            this.addAddedDependency(importer.getComponentName(), identifiable);
        }
    }

    public Map<String, List<Object>> getAdded() {
        return this.added;
    }

    public Map<String, List<Object>> getOverwritten() {
        return this.overwritten;
    }

    public void addOverwrittenDependency(String componentName, Object dependency) {
        this.overwritten = this.addDependency(this.overwritten, componentName, dependency);
    }

    public void addAddedDependency(String componentName, Object dependency) {
        this.added = this.addDependency(this.added, componentName, dependency);
    }

    private Map<String, List<Object>> addDependency(Map<String, List<Object>> map, String componentName, Object dependencies) {
        if (map == null) {
            map = new HashMap<String, List<Object>>();
        }
        map.computeIfAbsent(componentName, key -> new ArrayList()).add(dependencies);
        return map;
    }
}

