/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.i18n;

import java.io.IOException;
import java.nio.file.Path;
import org.bonitasoft.web.designer.common.IGeneratorProperties;
import org.bonitasoft.web.designer.config.DesignerInitializerException;
import org.bonitasoft.web.designer.i18n.LanguagePackBuilder;
import org.bonitasoft.web.designer.workspace.ResourcesCopier;

public class I18nInitializer {
    public static final String I18N_RESOURCES = "i18n";
    private final LanguagePackBuilder languagePackBuilder;
    private final ResourcesCopier resourcesCopier;
    private final IGeneratorProperties generatorProperties;

    public void initialize() {
        try {
            Path extractPath = this.generatorProperties.getExtractPath();
            this.resourcesCopier.copy(extractPath, I18N_RESOURCES);
            this.languagePackBuilder.start(extractPath.resolve(I18N_RESOURCES));
        }
        catch (IOException e) {
            throw new DesignerInitializerException("Unable to convert po files into json", e);
        }
    }

    public I18nInitializer(LanguagePackBuilder languagePackBuilder, ResourcesCopier resourcesCopier, IGeneratorProperties generatorProperties) {
        this.languagePackBuilder = languagePackBuilder;
        this.resourcesCopier = resourcesCopier;
        this.generatorProperties = generatorProperties;
    }
}

