/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.bonitasoft.web.designer.controller.asset.AssetService;
import org.bonitasoft.web.designer.migration.AbstractMigrationStep;
import org.bonitasoft.web.designer.model.JacksonJsonHandler;
import org.bonitasoft.web.designer.model.JsonHandler;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;
import org.bonitasoft.web.designer.model.page.Page;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalizationAddErrorDialogTranslationsMigrationStep
extends AbstractMigrationStep<Page> {
    private static final Logger log = LoggerFactory.getLogger(LocalizationAddErrorDialogTranslationsMigrationStep.class);
    private AssetService<Page> assetService;
    private JsonHandler jsonHandler;

    public LocalizationAddErrorDialogTranslationsMigrationStep(AssetService<Page> assetService) {
        this.assetService = assetService;
        this.jsonHandler = new JacksonJsonHandler(new ObjectMapper());
    }

    @Override
    public Optional<MigrationStepReport> migrate(Page artifact) throws IOException {
        for (Asset asset : artifact.getAssets()) {
            if (!asset.getName().equals("localization.json")) continue;
            byte[] pageLocalizationContent = this.assetService.getAssetBinaryContent(artifact, asset);
            this.assetService.save(artifact, asset, this.getMigratedAssetContent(pageLocalizationContent));
            log.info("[MIGRATION] Adding error dialog translations in asset [{}] to {} [{}] (introduced in 1.17.5)", new Object[]{asset.getName(), artifact.getType(), artifact.getName()});
        }
        return Optional.empty();
    }

    @Override
    public String getErrorMessage() {
        return "Error during adding error dialog translations in asset, Missing templates/page/assets/json/localization.json from classpath";
    }

    private byte[] getMigratedAssetContent(byte[] pageLocalizationContent) throws IOException {
        LinkedHashMap existingTranslations = this.jsonHandler.fromJsonToComplexMap(pageLocalizationContent);
        LinkedHashMap newLocalizationContent = new LinkedHashMap();
        try (InputStream is = this.getClass().getResourceAsStream("/templates/migration/assets/json/localizationAddErrorDialogTranslations.json");){
            LinkedHashMap translationsToAdd = this.jsonHandler.fromJsonToComplexMap(IOUtils.toByteArray((InputStream)is));
            for (String language : existingTranslations.keySet()) {
                LinkedHashMap existingLanguageTranslations = (LinkedHashMap)existingTranslations.get(language);
                LinkedHashMap languageTranslationsToAdd = (LinkedHashMap)translationsToAdd.get(language);
                LinkedHashMap mergedLanguageTranslations = new LinkedHashMap();
                mergedLanguageTranslations.putAll(existingLanguageTranslations);
                if (languageTranslationsToAdd != null) {
                    mergedLanguageTranslations.putAll(languageTranslationsToAdd);
                }
                newLocalizationContent.put(language, mergedLanguageTranslations);
            }
            Object object = this.jsonHandler.toPrettyJsonFromComplexMap(newLocalizationContent);
            return object;
        }
    }
}

