/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bonitasoft.web.designer.controller.asset.AssetService;
import org.bonitasoft.web.designer.migration.AbstractMigrationStep;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;
import org.bonitasoft.web.designer.model.page.Page;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StyleUpdateInputTypeMigrationStep
extends AbstractMigrationStep<Page> {
    private static final Logger logger = LoggerFactory.getLogger(StyleUpdateInputTypeMigrationStep.class);
    private static final String REGEX_SELECTOR = "(.*)(input\\[type='(?:text|url|password|number)']\\.ng-invalid\\.ng-dirty \\{)";
    String replacement = "$1input[type='url'].ng-invalid.ng-dirty,\n$2";
    private final AssetService<Page> pageAssetService;

    public StyleUpdateInputTypeMigrationStep(AssetService<Page> pageAssetService) {
        this.pageAssetService = pageAssetService;
    }

    @Override
    public Optional<MigrationStepReport> migrate(Page page) throws IOException {
        Pattern pattern = Pattern.compile(REGEX_SELECTOR);
        for (Asset asset : page.getAssets()) {
            String newContent;
            Matcher matcher;
            if (!asset.getName().equals("style.css") || !(matcher = pattern.matcher(newContent = this.pageAssetService.getAssetContent(page, asset))).find()) continue;
            String updatedStyleContent = newContent.replaceAll(REGEX_SELECTOR, this.replacement);
            this.pageAssetService.save(page, asset, updatedStyleContent.getBytes(StandardCharsets.UTF_8));
            logger.info("[MIGRATION] Update input style in asset [{}] for {} [{}]", new Object[]{asset.getName(), page.getType(), page.getName()});
        }
        return Optional.empty();
    }
}

