/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration.page;

import java.util.Optional;
import org.bonitasoft.web.designer.migration.AbstractMigrationStep;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;
import org.bonitasoft.web.designer.model.page.AbstractPage;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.PropertyValue;
import org.bonitasoft.web.designer.model.widget.BondType;
import org.bonitasoft.web.designer.visitor.ComponentVisitor;
import org.bonitasoft.web.designer.visitor.ElementVisitor;

public class AutocompleteWidgetReturnedKeyMigrationStep<T extends AbstractPage>
extends AbstractMigrationStep<T> {
    private ComponentVisitor componentVisitor;

    public AutocompleteWidgetReturnedKeyMigrationStep(ComponentVisitor componentVisitor) {
        this.componentVisitor = componentVisitor;
    }

    @Override
    public Optional<MigrationStepReport> migrate(AbstractPage page) throws Exception {
        for (Component component : (Iterable)page.accept((ElementVisitor)this.componentVisitor)) {
            PropertyValue displayedKeyValue;
            if (!"pbAutocomplete".equals(component.getId()) || (displayedKeyValue = (PropertyValue)component.getPropertyValues().get("displayedKey")) == null) continue;
            PropertyValue returnedKeyValue = new PropertyValue();
            returnedKeyValue.setType(BondType.INTERPOLATION.toJson());
            returnedKeyValue.setValue(displayedKeyValue.getValue());
            component.getPropertyValues().put("returnedKey", returnedKeyValue);
            PropertyValue newDisplayedKeyValue = new PropertyValue();
            newDisplayedKeyValue.setType(BondType.INTERPOLATION.toJson());
            newDisplayedKeyValue.setValue(displayedKeyValue.getValue());
            component.getPropertyValues().put("displayedKey", newDisplayedKeyValue);
        }
        return Optional.empty();
    }
}

