/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration.page;

import java.util.Optional;
import org.bonitasoft.web.designer.migration.AbstractMigrationStep;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;
import org.bonitasoft.web.designer.model.page.AbstractPage;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.PropertyValue;
import org.bonitasoft.web.designer.model.widget.BondType;
import org.bonitasoft.web.designer.visitor.ComponentVisitor;
import org.bonitasoft.web.designer.visitor.ElementVisitor;

public class TableWidgetStylesMigrationStep<T extends AbstractPage>
extends AbstractMigrationStep<T> {
    private static final String STRIPED_PROPERTY = "striped";
    private static final String CONDENSED_PROPERTY = "condensed";
    private static final String BORDERED_PROPERTY = "bordered";
    private ComponentVisitor componentVisitor;

    public TableWidgetStylesMigrationStep(ComponentVisitor componentVisitor) {
        this.componentVisitor = componentVisitor;
    }

    @Override
    public Optional<MigrationStepReport> migrate(AbstractPage page) {
        for (Component component : (Iterable)page.accept((ElementVisitor)this.componentVisitor)) {
            if (!this.isProvidedTableWidget(component.getId())) continue;
            this.setPropertyDefaultValue(component, STRIPED_PROPERTY, true);
            this.setPropertyDefaultValue(component, CONDENSED_PROPERTY, false);
            this.setPropertyDefaultValue(component, BORDERED_PROPERTY, false);
        }
        return Optional.empty();
    }

    @Override
    public String getErrorMessage() {
        return "An error occurred during table widget style migration";
    }

    private void setPropertyDefaultValue(Component component, String property, boolean defaultValue) {
        if (!component.getPropertyValues().containsKey(property)) {
            PropertyValue propertyValue = new PropertyValue();
            propertyValue.setType(BondType.CONSTANT.toJson());
            propertyValue.setValue((Object)defaultValue);
            component.getPropertyValues().put(property, propertyValue);
        }
    }

    private boolean isProvidedTableWidget(String componentId) {
        return "pbTable".equals(componentId) || "pbDataTable".equals(componentId);
    }
}

