/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.service;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.bonitasoft.web.designer.migration.Migration;
import org.bonitasoft.web.designer.model.migrationReport.MigrationResult;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WidgetMigrationApplyer {
    private static final Logger logger = LoggerFactory.getLogger(WidgetMigrationApplyer.class);
    private final List<Migration<Widget>> migrationList;

    public WidgetMigrationApplyer(List<Migration<Widget>> widgetMigrationStepsList) {
        this.migrationList = widgetMigrationStepsList;
    }

    public MigrationResult<Widget> migrate(Widget widget) {
        Instant startTime = Instant.now();
        String formerArtifactVersion = widget.getArtifactVersion();
        ArrayList<MigrationStepReport> l = new ArrayList<MigrationStepReport>();
        for (Migration<Widget> migration : this.migrationList) {
            l.addAll(migration.migrate(widget));
        }
        if (!StringUtils.equals((CharSequence)formerArtifactVersion, (CharSequence)widget.getArtifactVersion())) {
            widget.setPreviousArtifactVersion(formerArtifactVersion);
            float durationTime = (float)Duration.between(startTime, Instant.now()).toMillis() / 1000.0f;
            logger.info("[MIGRATION] Widget {} has been terminated in {} seconds !", (Object)widget.getName(), (Object)Float.valueOf(durationTime));
        }
        return new MigrationResult((Object)widget, l);
    }
}

