/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.utils.rule;

import java.nio.file.Path;
import org.bonitasoft.web.designer.Version;
import org.bonitasoft.web.designer.builder.WidgetBuilder;
import org.bonitasoft.web.designer.common.livebuild.Watcher;
import org.bonitasoft.web.designer.common.repository.JsonFileBasedLoader;
import org.bonitasoft.web.designer.common.repository.JsonFileBasedPersister;
import org.bonitasoft.web.designer.common.repository.WidgetFileBasedLoader;
import org.bonitasoft.web.designer.common.repository.WidgetRepository;
import org.bonitasoft.web.designer.config.UiDesignerProperties;
import org.bonitasoft.web.designer.config.WorkspaceProperties;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.JsonHandler;
import org.bonitasoft.web.designer.model.JsonHandlerFactory;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.repository.BeanValidator;
import org.mockito.Mockito;

public class TemporaryWidgetRepository {
    private JsonHandler jsonHandler = new JsonHandlerFactory().create();
    private WidgetRepository repository;
    private WorkspaceProperties workspaceProperties;
    private Path tempPath;

    public TemporaryWidgetRepository(WorkspaceProperties workspaceProperties) {
        this.workspaceProperties = workspaceProperties;
    }

    public void init(Path tempPath) throws Throwable {
        this.tempPath = tempPath;
        this.workspaceProperties.getWidgets().setDir(tempPath);
        UiDesignerProperties uiDesignerProperties = new UiDesignerProperties("1.13.0", Version.MODEL_VERSION);
        uiDesignerProperties.setWorkspace(this.workspaceProperties);
        this.repository = new WidgetRepository(this.workspaceProperties.getWidgets().getDir(), uiDesignerProperties.getWorkspaceUid().getExtractPath().resolve("angularjs").resolve("templates"), new JsonFileBasedPersister(this.jsonHandler, (BeanValidator)Mockito.mock(BeanValidator.class), "1.13.0", Version.MODEL_VERSION), (JsonFileBasedLoader)new WidgetFileBasedLoader(this.jsonHandler), (BeanValidator)Mockito.mock(BeanValidator.class), (Watcher)Mockito.mock(Watcher.class));
    }

    public Path resolveWidgetJson(String id) {
        return this.tempPath.resolve(String.format("%s/%s.json", id, id));
    }

    public Path resolveWidgetMetadata(String id) {
        return this.tempPath.resolve(String.format("%s/%s.metadata.json", id, id));
    }

    public Widget addWidget(WidgetBuilder widgetBuilder) {
        return (Widget)this.repository.save((Identifiable)widgetBuilder.build());
    }
}

