/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.visitor;

import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.ComponentBuilder;
import org.bonitasoft.web.designer.builder.ContainerBuilder;
import org.bonitasoft.web.designer.builder.FormContainerBuilder;
import org.bonitasoft.web.designer.builder.ModalContainerBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.builder.TabContainerBuilder;
import org.bonitasoft.web.designer.builder.TabsContainerBuilder;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.Container;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.model.page.FormContainer;
import org.bonitasoft.web.designer.model.page.ModalContainer;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.model.page.TabContainer;
import org.bonitasoft.web.designer.model.page.TabsContainer;
import org.bonitasoft.web.designer.visitor.AnyLocalContainerVisitor;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class AnyLocalContainerVisitorTest {
    @InjectMocks
    private AnyLocalContainerVisitor anyLocalContainerVisitor;
    private Component component;

    AnyLocalContainerVisitorTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.component = ComponentBuilder.aComponent().build();
    }

    @Test
    void should_not_collect_components() throws Exception {
        Assertions.assertThat((Iterable)this.anyLocalContainerVisitor.visit(this.component)).isEmpty();
    }

    @Test
    void should_collect_containers() throws Exception {
        Container container = ContainerBuilder.aContainer().with(new Element[]{this.component}).build();
        Assertions.assertThat((Iterable)this.anyLocalContainerVisitor.visit(container)).containsExactly((Object[])new Element[]{container});
    }

    @Test
    void should_collect_tabs_containers_and_content() throws Exception {
        Container container = ContainerBuilder.aContainer().build();
        TabContainer tab = TabContainerBuilder.aTabContainer().with(container).build();
        TabsContainer tabsContainer = TabsContainerBuilder.aTabsContainer().with(new TabContainer[]{tab}).build();
        Assertions.assertThat((Iterable)this.anyLocalContainerVisitor.visit(tabsContainer)).containsExactly((Object[])new Element[]{tabsContainer, tab, container});
    }

    @Test
    void should_collect_form_containers_and_content() throws Exception {
        Container container = ContainerBuilder.aContainer().build();
        FormContainer formContainer = FormContainerBuilder.aFormContainer().with(container).build();
        Assertions.assertThat((Iterable)this.anyLocalContainerVisitor.visit(formContainer)).containsExactly((Object[])new Element[]{formContainer, container});
    }

    @Test
    void should_collect_container_within_previewable() throws Exception {
        Container container = ContainerBuilder.aContainer().build();
        Assertions.assertThat((Iterable)this.anyLocalContainerVisitor.visit((Previewable)PageBuilder.aPage().with(new Element[]{container}).build())).containsExactly((Object[])new Element[]{container});
    }

    @Test
    void should_collect_modalContainer() throws Exception {
        Container container = ContainerBuilder.aContainer().with(new Element[]{this.component}).build();
        ModalContainer modalContainer = ModalContainerBuilder.aModalContainer().with(container).build();
        Assertions.assertThat((Iterable)this.anyLocalContainerVisitor.visit(modalContainer)).contains((Object[])new Element[]{modalContainer, container});
    }
}

