/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration.page;

import java.util.Optional;
import org.bonitasoft.web.designer.migration.AbstractMigrationStep;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;
import org.bonitasoft.web.designer.model.page.AbstractPage;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.visitor.ComponentVisitor;
import org.bonitasoft.web.designer.visitor.ElementVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessibilityCheckListAndRadioButtonsMigrationStep<T extends AbstractPage>
extends AbstractMigrationStep<T> {
    private static final Logger log = LoggerFactory.getLogger(AccessibilityCheckListAndRadioButtonsMigrationStep.class);
    private ComponentVisitor componentVisitor;

    public AccessibilityCheckListAndRadioButtonsMigrationStep(ComponentVisitor componentVisitor) {
        this.componentVisitor = componentVisitor;
    }

    @Override
    public Optional<MigrationStepReport> migrate(AbstractPage page) throws Exception {
        for (Component component : (Iterable)page.accept((ElementVisitor)this.componentVisitor)) {
            if (!this.isProvidedCheckListOrRadiobuttonsWidget(component.getId())) continue;
            String msg = "Internal HTML template for Checklist and Radiobuttons have been update. Please check your css selector if you apply some custom style on theses widgets. You can find more details in Editor > Help > Migration section.";
            log.info("[MIGRATION] [{}] {}", (Object)page.getName(), (Object)msg);
            return Optional.of(MigrationStepReport.warningMigrationReport((String)page.getName(), (String)msg, (String)this.getClass().getName()));
        }
        return Optional.empty();
    }

    private boolean isProvidedCheckListOrRadiobuttonsWidget(String componentId) {
        return "pbChecklist".equals(componentId) || "pbRadioButtons".equals(componentId);
    }
}

