/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.visitor;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bonitasoft.web.designer.common.repository.FragmentRepository;
import org.bonitasoft.web.designer.common.repository.WidgetRepository;
import org.bonitasoft.web.designer.controller.export.properties.BonitaBusinessDataResourcePredicate;
import org.bonitasoft.web.designer.controller.export.properties.BonitaResourceTransformer;
import org.bonitasoft.web.designer.controller.export.properties.BonitaVariableResourcePredicate;
import org.bonitasoft.web.designer.controller.export.properties.ResourceURLFunction;
import org.bonitasoft.web.designer.model.ParameterType;
import org.bonitasoft.web.designer.model.data.Variable;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.Container;
import org.bonitasoft.web.designer.model.page.FormContainer;
import org.bonitasoft.web.designer.model.page.FragmentElement;
import org.bonitasoft.web.designer.model.page.ModalContainer;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.model.page.PropertyValue;
import org.bonitasoft.web.designer.model.page.TabContainer;
import org.bonitasoft.web.designer.model.page.TabsContainer;
import org.bonitasoft.web.designer.model.page.WebResource;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.visitor.ElementVisitor;

public class WebResourcesVisitor
implements ElementVisitor<Map<String, WebResource>> {
    static final String SUBMIT_TASK = "Submit task";
    private static final String START_PROCESS = "Start process";
    private static final String BUSINESS_DATA_RESOURCE = "GET|bdm/businessData";
    private static final String BUSINESS_DATA_QUERY_RESOURCE = "GET|bdm/businessDataQuery";
    private final FragmentRepository fragmentRepository;
    private final WidgetRepository widgetRepository;
    public static final String BONITA_RESOURCE_REGEX = ".+/API/(?!extension)([^ /]*)/([^ /(?|{)]*)[\\S+]*";
    public static final String EXTENSION_RESOURCE_REGEX = ".+/API/(?=extension)([^ /]*)/([^ (?|{)]*).*";

    public Map<String, WebResource> visit(FragmentElement fragmentElement) {
        HashMap<String, WebResource> mapResources = new HashMap<String, WebResource>();
        Fragment fragment = (Fragment)this.fragmentRepository.get(fragmentElement.getId());
        this.addResourceScope(mapResources, this.getResourcesFromVariables(fragment.getVariables()), "Variable");
        fragment.getWebResources().stream().forEach(wr -> this.overrideScopeToKeepOnlyOneLevel(fragmentElement, (Map<String, WebResource>)mapResources, (WebResource)wr));
        ((Map)fragment.toContainer(fragmentElement).accept((ElementVisitor)this)).values().stream().forEach(wr -> this.overrideScopeToKeepOnlyOneLevel(fragmentElement, (Map<String, WebResource>)mapResources, (WebResource)wr));
        return mapResources;
    }

    public Map<String, WebResource> visit(Component component) {
        HashMap<String, WebResource> mapResources = new HashMap<String, WebResource>();
        if (this.withAction(component, START_PROCESS)) {
            mapResources.put("POST|bpm/process", new WebResource("POST", "bpm/process", component.getId()));
        }
        if (this.withAction(component, SUBMIT_TASK)) {
            mapResources.put("POST|bpm/userTask", new WebResource("POST", "bpm/userTask", component.getId()));
        }
        this.addIfExist(component, "GET", "url").ifPresent(wr -> mapResources.put(wr.toDefinition(), (WebResource)wr));
        this.addIfExist(component, "POST", "url").ifPresent(wr -> mapResources.put(wr.toDefinition(), (WebResource)wr));
        this.addIfExist(component, "PUT", "url").ifPresent(wr -> mapResources.put(wr.toDefinition(), (WebResource)wr));
        this.addIfExist(component, "DELETE", "url").ifPresent(wr -> mapResources.put(wr.toDefinition(), (WebResource)wr));
        this.findResourcesIn(component, "apiUrl", "GET").ifPresent(s -> mapResources.put(String.format("GET|%s", s), new WebResource("GET", s, component.getId())));
        if ("pbUpload".equals(component.getId())) {
            this.findResourcesIn(component, "url", "POST").ifPresent(s -> mapResources.put(String.format("POST|%s", s), new WebResource("POST", s, component.getId())));
        }
        Widget widget = (Widget)this.widgetRepository.get(component.getId());
        widget.getWebResources().stream().forEach(wr -> {
            wr.setScopes(Set.of(component.getId()));
            wr.setAutomatic(true);
            mapResources.put(wr.toDefinition(), (WebResource)wr);
        });
        return mapResources;
    }

    private Optional<WebResource> addIfExist(Component component, String httpVerb, String propertyName) {
        Optional<String> resources;
        if (this.withAction(component, httpVerb) && (resources = this.findResourcesIn(component, propertyName, httpVerb)).isPresent()) {
            return Optional.of(new WebResource(httpVerb, resources.get(), component.getId()));
        }
        return Optional.empty();
    }

    private Optional<String> findResourcesIn(Component component, String propertyName, String httpVerb) {
        return Optional.ofNullable(component).map(this.propertyValue(propertyName)).filter(Objects::nonNull).filter(this.propertyType(ParameterType.CONSTANT).or(this.propertyType(ParameterType.INTERPOLATION))).filter(this.notNullOrEmptyValue()).map(this.toPageResource(httpVerb)).filter(Objects::nonNull);
    }

    private Predicate<? super PropertyValue> notNullOrEmptyValue() {
        return propertyValue -> propertyValue.getValue() != null && !propertyValue.getValue().toString().isEmpty();
    }

    private Function<PropertyValue, String> toPageResource(String httpVerb) {
        return propertyValue -> {
            String value = propertyValue.getValue().toString();
            return value.matches(BONITA_RESOURCE_REGEX) ? new ResourceURLFunction(BONITA_RESOURCE_REGEX, httpVerb).applyApi(value) : (value.matches(EXTENSION_RESOURCE_REGEX) ? new ResourceURLFunction(EXTENSION_RESOURCE_REGEX, httpVerb).applyApi(value) : null);
        };
    }

    private Function<Component, PropertyValue> propertyValue(String propertyName) {
        return component -> (PropertyValue)component.getPropertyValues().get(propertyName);
    }

    private Predicate<PropertyValue> propertyType(ParameterType type) {
        return propertyValue -> Objects.equals(type.getValue(), propertyValue.getType());
    }

    public Map<String, WebResource> visit(Container container) {
        HashMap<String, WebResource> data = new HashMap<String, WebResource>();
        container.getRows().forEach(rows -> rows.forEach(el -> data.putAll((Map)el.accept((ElementVisitor)this))));
        return data;
    }

    public Map<String, WebResource> visit(FormContainer formContainer) {
        return (Map)formContainer.getContainer().accept((ElementVisitor)this);
    }

    public Map<String, WebResource> visit(TabsContainer tabsContainer) {
        HashMap<String, WebResource> data = new HashMap<String, WebResource>();
        tabsContainer.getTabList().forEach(tabContainer -> data.putAll((Map)tabContainer.accept((ElementVisitor)this)));
        return data;
    }

    public Map<String, WebResource> visit(TabContainer tabContainer) {
        return (Map)tabContainer.getContainer().accept((ElementVisitor)this);
    }

    public Map<String, WebResource> visit(ModalContainer modalContainer) {
        return (Map)modalContainer.getContainer().accept((ElementVisitor)this);
    }

    public Map<String, WebResource> visit(Previewable previewable) {
        HashMap<String, WebResource> mapResources = new HashMap<String, WebResource>();
        this.addResourceScope(mapResources, this.getResourcesFromVariables(previewable.getVariables()), "Variable");
        previewable.getRows().stream().forEach(row -> row.stream().forEach(element -> this.addWebResourceScope(mapResources, ((Map)element.accept((ElementVisitor)this)).values().stream().collect(Collectors.toList()))));
        return mapResources;
    }

    private List<String> getResourcesFromVariables(Map<String, Variable> variables) {
        List<String> resources = variables.values().stream().filter(new BonitaVariableResourcePredicate(BONITA_RESOURCE_REGEX)).map(new BonitaResourceTransformer(BONITA_RESOURCE_REGEX)).filter(Objects::nonNull).collect(Collectors.toList());
        variables.values().stream().filter(new BonitaVariableResourcePredicate(EXTENSION_RESOURCE_REGEX)).map(new BonitaResourceTransformer(EXTENSION_RESOURCE_REGEX)).filter(Objects::nonNull).forEach(resources::add);
        if (WebResourcesVisitor.containsBusinessDataVariable(variables.values())) {
            resources.add(BUSINESS_DATA_RESOURCE);
            resources.add(BUSINESS_DATA_QUERY_RESOURCE);
        }
        return resources;
    }

    private static boolean containsBusinessDataVariable(Collection<Variable> variables) {
        return variables.stream().anyMatch(new BonitaBusinessDataResourcePredicate());
    }

    private boolean withAction(Component component, String action) {
        return component.getPropertyValues().containsKey("action") && Objects.equals(action, String.valueOf(((PropertyValue)component.getPropertyValues().get("action")).getValue()));
    }

    private void addResourceScope(Map<String, WebResource> mapResources, List<String> entryResources, String scope) {
        entryResources.forEach(r -> {
            if (mapResources.containsKey(r)) {
                ((WebResource)mapResources.get(r)).addToScopes(scope);
            } else if (!r.isEmpty()) {
                WebResource wr = new WebResource(r.split("\\|")[0], r.split("\\|")[1], scope);
                mapResources.put((String)r, wr);
            }
        });
    }

    private void addWebResourceScope(Map<String, WebResource> mapResources, List<WebResource> wr) {
        wr.forEach(r -> {
            if (mapResources.containsKey(r.toDefinition())) {
                ((WebResource)mapResources.get(r.toDefinition())).getScopes().addAll(r.getScopes());
            } else {
                mapResources.put(r.toDefinition(), (WebResource)r);
            }
        });
    }

    private void overrideScopeToKeepOnlyOneLevel(FragmentElement fragmentElement, Map<String, WebResource> mapResources, WebResource wr) {
        wr.setScopes(Arrays.asList(fragmentElement.getId()).stream().collect(Collectors.toSet()));
        wr.setAutomatic(true);
        mapResources.put(wr.toDefinition(), wr);
    }

    public WebResourcesVisitor(FragmentRepository fragmentRepository, WidgetRepository widgetRepository) {
        this.fragmentRepository = fragmentRepository;
        this.widgetRepository = widgetRepository;
    }
}

