/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer;

import java.io.IOException;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.DefaultArtifactBuilder;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.builder.WidgetBuilder;
import org.bonitasoft.web.designer.common.generator.rendering.HtmlGenerator;
import org.bonitasoft.web.designer.controller.export.FragmentExporter;
import org.bonitasoft.web.designer.controller.export.PageExporter;
import org.bonitasoft.web.designer.controller.export.WidgetExporter;
import org.bonitasoft.web.designer.controller.importer.FragmentImporter;
import org.bonitasoft.web.designer.controller.importer.ImportStore;
import org.bonitasoft.web.designer.controller.importer.PageImporter;
import org.bonitasoft.web.designer.controller.importer.WidgetImporter;
import org.bonitasoft.web.designer.model.ArtifactStatusReport;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.ModelException;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.service.FragmentService;
import org.bonitasoft.web.designer.service.PageService;
import org.bonitasoft.web.designer.service.WidgetService;
import org.bonitasoft.web.designer.workspace.Workspace;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class DefaultArtifactBuilderTest {
    private DefaultArtifactBuilder artifactBuilder;
    @Mock
    private PageService pageService;
    @Mock
    private FragmentService fragmentService;
    @Mock
    private WidgetService widgetService;

    DefaultArtifactBuilderTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.artifactBuilder = new DefaultArtifactBuilder((Workspace)Mockito.mock(Workspace.class), this.widgetService, this.fragmentService, this.pageService, (PageExporter)Mockito.mock(PageExporter.class), (FragmentExporter)Mockito.mock(FragmentExporter.class), (WidgetExporter)Mockito.mock(WidgetExporter.class), (HtmlGenerator)Mockito.mock(HtmlGenerator.class), new ImportStore(), (PageImporter)Mockito.mock(PageImporter.class), (FragmentImporter)Mockito.mock(FragmentImporter.class), (WidgetImporter)Mockito.mock(WidgetImporter.class));
    }

    @Test
    void build_page_should_call_page_service() throws ModelException, IOException {
        String id = UUID.randomUUID().toString();
        Mockito.when((Object)((Page)this.pageService.get(id))).thenReturn((Object)PageBuilder.aPage().withId(id).withName(id).build());
        this.artifactBuilder.buildPage(id);
        ((PageService)Mockito.verify((Object)this.pageService)).get(id);
    }

    @Test
    void build_fragment_should_call_page_service() throws ModelException, IOException {
        String id = UUID.randomUUID().toString();
        Mockito.when((Object)((Fragment)this.fragmentService.get(id))).thenReturn((Object)FragmentBuilder.aFragment().withId(id).withName(id).build());
        this.artifactBuilder.buildFragment(id);
        ((FragmentService)Mockito.verify((Object)this.fragmentService)).get(id);
    }

    @Test
    void build_widget_should_call_page_service() throws ModelException, IOException {
        String id = UUID.randomUUID().toString();
        Mockito.when((Object)this.widgetService.get(id)).thenReturn((Object)WidgetBuilder.aWidget().withId(id).withName(id).build());
        this.artifactBuilder.buildWidget(id);
        ((WidgetService)Mockito.verify((Object)this.widgetService)).get(id);
    }

    @Test
    void get_page_status_should_call_page_service() {
        ArtifactStatusReport status = new ArtifactStatusReport();
        Page page = PageBuilder.aPage().build();
        Mockito.when((Object)this.pageService.getStatus((Identifiable)page)).thenReturn((Object)status);
        ArtifactStatusReport result = this.artifactBuilder.getPageStatus(page);
        ((PageService)Mockito.verify((Object)this.pageService)).getStatus((Identifiable)page);
        Assertions.assertThat((Object)result).isEqualTo((Object)status);
    }

    @Test
    void get_page_status_by_id_should_call_page_service() {
        String id = UUID.randomUUID().toString();
        ArtifactStatusReport status = new ArtifactStatusReport();
        Page page = PageBuilder.aPage().withId(id).withArtifactStatusReport(status).build();
        Mockito.when((Object)((Page)this.pageService.get(id))).thenReturn((Object)page);
        ArtifactStatusReport result = this.artifactBuilder.getPageStatus(id);
        ((PageService)Mockito.verify((Object)this.pageService)).get(id);
        Assertions.assertThat((Object)result).isEqualTo((Object)status);
    }

    @Test
    void get_fragment_status_should_call_fragment_service() {
        ArtifactStatusReport status = new ArtifactStatusReport();
        Fragment fragment = FragmentBuilder.aFragment().build();
        Mockito.when((Object)this.fragmentService.getStatus((Identifiable)fragment)).thenReturn((Object)status);
        ArtifactStatusReport result = this.artifactBuilder.getFragmentStatus(fragment);
        ((FragmentService)Mockito.verify((Object)this.fragmentService)).getStatus((Identifiable)fragment);
        Assertions.assertThat((Object)result).isEqualTo((Object)status);
    }

    @Test
    void get_fragment_status_by_id_should_call_fragment_service() {
        String id = UUID.randomUUID().toString();
        ArtifactStatusReport status = new ArtifactStatusReport();
        Fragment fragment = FragmentBuilder.aFragment().withId(id).withArtifactStatusReport(status).build();
        Mockito.when((Object)((Fragment)this.fragmentService.get(id))).thenReturn((Object)fragment);
        ArtifactStatusReport result = this.artifactBuilder.getFragmentStatus(id);
        ((FragmentService)Mockito.verify((Object)this.fragmentService)).get(id);
        Assertions.assertThat((Object)result).isEqualTo((Object)status);
    }

    @Test
    void get_widget_status_should_call_widget_service() {
        ArtifactStatusReport status = new ArtifactStatusReport();
        Widget widget = WidgetBuilder.aWidget().build();
        Mockito.when((Object)this.widgetService.getStatus((Identifiable)widget)).thenReturn((Object)status);
        ArtifactStatusReport result = this.artifactBuilder.getWidgetStatus(widget);
        ((WidgetService)Mockito.verify((Object)this.widgetService)).getStatus((Identifiable)widget);
        Assertions.assertThat((Object)result).isEqualTo((Object)status);
    }

    @Test
    void get_widget_status_by_id_should_call_widget_service() {
        String id = UUID.randomUUID().toString();
        ArtifactStatusReport status = new ArtifactStatusReport();
        Widget widget = WidgetBuilder.aWidget().withId(id).withArtifactStatusReport(status).build();
        Mockito.when((Object)this.widgetService.get(id)).thenReturn((Object)widget);
        ArtifactStatusReport result = this.artifactBuilder.getWidgetStatus(id);
        ((WidgetService)Mockito.verify((Object)this.widgetService)).get(id);
        Assertions.assertThat((Object)result).isEqualTo((Object)status);
    }
}

