/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.DefaultArtifactBuilder;
import org.bonitasoft.web.designer.common.generator.rendering.HtmlGenerator;
import org.bonitasoft.web.designer.controller.export.FragmentExporter;
import org.bonitasoft.web.designer.controller.export.PageExporter;
import org.bonitasoft.web.designer.controller.export.WidgetExporter;
import org.bonitasoft.web.designer.controller.importer.FragmentImporter;
import org.bonitasoft.web.designer.controller.importer.ImportException;
import org.bonitasoft.web.designer.controller.importer.ImportStore;
import org.bonitasoft.web.designer.controller.importer.PageImporter;
import org.bonitasoft.web.designer.controller.importer.WidgetImporter;
import org.bonitasoft.web.designer.service.FragmentService;
import org.bonitasoft.web.designer.service.PageService;
import org.bonitasoft.web.designer.service.WidgetService;
import org.bonitasoft.web.designer.workspace.Workspace;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class DefaultArtifactImporterTest {
    @TempDir
    public Path tempDir;
    private DefaultArtifactBuilder artifactImporter;
    private Path resources;

    DefaultArtifactImporterTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        ImportStore importStore = new ImportStore();
        PageImporter pageImporter = (PageImporter)Mockito.mock(PageImporter.class);
        FragmentImporter fragmentImporter = (FragmentImporter)Mockito.mock(FragmentImporter.class);
        WidgetImporter widgetImporter = (WidgetImporter)Mockito.mock(WidgetImporter.class);
        Workspace workspace = (Workspace)Mockito.mock(Workspace.class);
        PageExporter pageExporter = (PageExporter)Mockito.mock(PageExporter.class);
        FragmentExporter fragmentExporter = (FragmentExporter)Mockito.mock(FragmentExporter.class);
        WidgetExporter widgetExporter = (WidgetExporter)Mockito.mock(WidgetExporter.class);
        HtmlGenerator htmlGenerator = (HtmlGenerator)Mockito.mock(HtmlGenerator.class);
        this.artifactImporter = (DefaultArtifactBuilder)Mockito.spy((Object)new DefaultArtifactBuilder(workspace, (WidgetService)Mockito.mock(WidgetService.class), (FragmentService)Mockito.mock(FragmentService.class), (PageService)Mockito.mock(PageService.class), pageExporter, fragmentExporter, widgetExporter, htmlGenerator, importStore, pageImporter, fragmentImporter, widgetImporter));
        this.resources = Files.createDirectory(this.tempDir.resolve("resources"), new FileAttribute[0]);
    }

    @Test
    void should_throw_NotFoundException_for_an_unknown_artifact_type() throws Exception {
        boolean force = true;
        org.junit.jupiter.api.Assertions.assertThrows(ImportException.class, () -> this.artifactImporter.importArtifact(this.tempDir, true));
    }

    @ParameterizedTest
    @ValueSource(strings={"page", "fragment", "widget"})
    void should_get_fragment_importer_from_type(String artifactType) throws Exception {
        ((DefaultArtifactBuilder)Mockito.doReturn((Object)artifactType).when((Object)this.artifactImporter)).resolveArtifactType((Path)ArgumentMatchers.any());
        boolean force = true;
        this.artifactImporter.importArtifact(this.tempDir, true);
        switch (artifactType) {
            case "page": {
                ((DefaultArtifactBuilder)Mockito.verify((Object)this.artifactImporter)).importPage((Path)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true));
                break;
            }
            case "fragment": {
                ((DefaultArtifactBuilder)Mockito.verify((Object)this.artifactImporter)).importFragment((Path)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true));
                break;
            }
            case "widget": {
                ((DefaultArtifactBuilder)Mockito.verify((Object)this.artifactImporter)).importWidget((Path)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true));
                break;
            }
            default: {
                Assertions.fail((String)"unknown artifact type");
            }
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"page", "fragment", "widget"})
    void should_get_importer_from_path(String artifactType) throws Exception {
        Files.createFile(this.resources.resolve(artifactType + ".json"), new FileAttribute[0]);
        boolean force = true;
        this.artifactImporter.importArtifact(this.tempDir, true);
        switch (artifactType) {
            case "page": {
                ((DefaultArtifactBuilder)Mockito.verify((Object)this.artifactImporter)).importPage((Path)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true));
                break;
            }
            case "fragment": {
                ((DefaultArtifactBuilder)Mockito.verify((Object)this.artifactImporter)).importFragment((Path)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true));
                break;
            }
            case "widget": {
                ((DefaultArtifactBuilder)Mockito.verify((Object)this.artifactImporter)).importWidget((Path)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true));
                break;
            }
            default: {
                Assertions.fail((String)"unknown artifact type");
            }
        }
    }

    @Test
    void should_get_ImportException_while_resources_folder_is_absent() throws Exception {
        Files.delete(this.resources);
        ImportException importException = (ImportException)org.junit.jupiter.api.Assertions.assertThrows(ImportException.class, () -> this.artifactImporter.importArtifact(this.tempDir, true));
        Assertions.assertThat((Comparable)importException.getType()).isEqualTo((Object)ImportException.Type.UNEXPECTED_ZIP_STRUCTURE);
        Assertions.assertThat((String)importException.getMessage()).isEqualTo("Incorrect zip structure, resources folder is needed");
    }

    @Test
    void should_get_ImportException_while_no_importer_found_from_path() throws Exception {
        ImportException importException = (ImportException)org.junit.jupiter.api.Assertions.assertThrows(ImportException.class, () -> this.artifactImporter.importArtifact(this.tempDir, true));
        Assertions.assertThat((Comparable)importException.getType()).isEqualTo((Object)ImportException.Type.MODEL_NOT_FOUND);
        Assertions.assertThat((String)importException.getMessage()).isEqualTo("Could not load component, artifact model file not found");
        Collection modelfiles = (Collection)importException.getInfos().get("modelfiles");
        Assertions.assertThat((Collection)modelfiles).containsOnly((Object[])new String[]{"page.json", "widget.json", "fragment.json"});
    }
}

