/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.builder;

import java.nio.file.Path;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.Version;
import org.bonitasoft.web.designer.config.UiDesignerProperties;
import org.bonitasoft.web.designer.config.UiDesignerPropertiesBuilder;
import org.junit.jupiter.api.Test;

class UiDesignerPropertiesBuilderTest {
    UiDesignerPropertiesBuilderTest() {
    }

    @Test
    void default_props_should_be_set() {
        UiDesignerProperties properties = new UiDesignerPropertiesBuilder().workspacePath(Path.of("some/place/", new String[0])).build();
        Assertions.assertThat((String)properties.getVersion()).isEqualTo(Version.VERSION);
        Assertions.assertThat((String)properties.getEdition()).isEqualTo(Version.EDITION);
        Assertions.assertThat((String)properties.getModelVersion()).isEqualTo(Version.MODEL_VERSION);
    }

    @Test
    void default_paths_should_be_set() {
        Path workspacePath = Path.of("some", "place");
        UiDesignerProperties properties = new UiDesignerPropertiesBuilder().workspacePath(workspacePath).build();
        Assertions.assertThat((Path)properties.getWorkspace().getPath()).isEqualTo((Object)workspacePath);
        Assertions.assertThat((Object)properties.getWorkspaceUid()).isNotNull();
    }

    @Test
    void should_override_default_folder_name() {
        Path workspacePath = Path.of("some", "place");
        String pageFolder = "web-pages";
        String fragmentFolder = "web-fragments";
        String widgetFolder = "web-widgets";
        UiDesignerProperties properties = new UiDesignerPropertiesBuilder().workspacePath(workspacePath).pagesFolderName(pageFolder).fragmentsFolderName(fragmentFolder).widgetsFolderName(widgetFolder).build();
        Assertions.assertThat((Path)properties.getWorkspace().getPath()).isEqualTo((Object)workspacePath);
        Assertions.assertThat((Path)properties.getWorkspace().getPages().getDir()).isEqualTo((Object)properties.getWorkspace().getPath().resolve(pageFolder));
    }
}

