/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.builder;

import java.nio.file.Path;
import org.bonitasoft.web.designer.config.DesignerInitializerException;
import org.bonitasoft.web.designer.config.UiDesignerProperties;
import org.bonitasoft.web.designer.config.WorkspaceProperties;

public class UiDesignerPropertiesTestBuilder {
    private Path workspacePath;

    public static UiDesignerPropertiesTestBuilder aUiDesignerPropertiesBuilder() {
        return new UiDesignerPropertiesTestBuilder();
    }

    public static UiDesignerProperties aUiDesignerProperties(Path workspacePath) {
        return UiDesignerPropertiesTestBuilder.aUiDesignerPropertiesBuilder().withWorkspacePath(workspacePath).build();
    }

    private UiDesignerPropertiesTestBuilder withWorkspacePath(Path workspacePath) {
        this.workspacePath = workspacePath;
        return this;
    }

    public UiDesignerProperties build() {
        if (this.workspacePath == null) {
            throw new DesignerInitializerException("Workspace Path can not be null.");
        }
        UiDesignerProperties uiDesignerProperties = new UiDesignerProperties();
        WorkspaceProperties workspaceProperties = uiDesignerProperties.getWorkspace();
        workspaceProperties.getPages().setDir(this.workspacePath.resolve("pages"));
        workspaceProperties.getWidgets().setDir(this.workspacePath.resolve("widgets"));
        workspaceProperties.getFragments().setDir(this.workspacePath.resolve("fragments"));
        return uiDesignerProperties;
    }
}

