/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.export;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.io.FileUtils;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.common.export.ExportStep;
import org.bonitasoft.web.designer.common.export.Zipper;
import org.bonitasoft.web.designer.common.repository.exception.NotFoundException;
import org.bonitasoft.web.designer.controller.export.ExportException;
import org.bonitasoft.web.designer.controller.export.PageExporter;
import org.bonitasoft.web.designer.controller.utils.Unzipper;
import org.bonitasoft.web.designer.model.JsonHandler;
import org.bonitasoft.web.designer.model.JsonHandlerFactory;
import org.bonitasoft.web.designer.model.JsonViewPersistence;
import org.bonitasoft.web.designer.model.ModelException;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.service.PageService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class PageExporterTest {
    @Mock
    private PageService pageService;
    private final JsonHandler jsonHandler = new JsonHandlerFactory().create();
    private PageExporter exporter;
    private ByteArrayOutputStream artifactStream;

    PageExporterTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.artifactStream = new ByteArrayOutputStream();
        this.exporter = new PageExporter(this.jsonHandler, this.pageService, new ExportStep[]{(ExportStep)Mockito.mock(ExportStep.class)});
    }

    private Page create(Page page, Path tmpDir) throws IOException {
        if (page.getId() == null) {
            page.setId("default-id");
        }
        Mockito.when((Object)((Page)this.pageService.get(page.getId()))).thenReturn((Object)page);
        Files.write(tmpDir.resolve(String.format("%s.json", page.getId())), this.jsonHandler.toJson((Object)page, JsonViewPersistence.class), new OpenOption[0]);
        return page;
    }

    private Path unzip(ByteArrayOutputStream artifactZipStream) throws IOException {
        return new Unzipper().unzipInTempDir((InputStream)new ByteArrayInputStream(artifactZipStream.toByteArray()), "exportertest");
    }

    @Test
    void should_throw_exception_when_id_is_null() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.exporter.handleFileExport(null, (OutputStream)this.artifactStream));
    }

    @Test
    void should_throw_exception_when_id_is_blank() {
        org.junit.jupiter.api.Assertions.assertThrows(IllegalArgumentException.class, () -> this.exporter.handleFileExport(" ", (OutputStream)this.artifactStream));
    }

    @Test
    void should_throw_exception_when_artefact_to_export_is_not_found() {
        NotFoundException cause = new NotFoundException("Page not found");
        Mockito.when((Object)((Page)this.pageService.get("unknown-id"))).thenThrow(new Throwable[]{cause});
        Throwable throwable = Assertions.catchThrowable(() -> this.exporter.handleFileExport("unknown-id", (OutputStream)this.artifactStream));
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)throwable).isInstanceOf(ExportException.class)).hasCause((Throwable)cause);
    }

    @Test
    void should_failed_when_page_is_not_compatible_with_product_model_version(@TempDir Path tmpDir) throws Exception {
        Page page = this.create(PageBuilder.aPage().withModelVersion("5.0").isCompatible(false).build(), tmpDir);
        org.junit.jupiter.api.Assertions.assertThrows(ModelException.class, () -> this.exporter.handleFileExport(page.getId(), (OutputStream)this.artifactStream));
    }

    @Test
    void should_fill_output_stream(@TempDir Path tmpDir) throws Exception {
        Page page = this.create(PageBuilder.aPage().withType("layout").withName("thelayout").build(), tmpDir);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.exporter.handleFileExport(page.getId(), (OutputStream)stream);
        Assertions.assertThat((int)stream.size()).isPositive();
    }

    @Test
    void should_export_json_model_of_the_exported_artefact(@TempDir Path tmpDir) throws Exception {
        Page page = this.create(PageBuilder.aPage().withId("myPage").build(), tmpDir);
        this.exporter.handleFileExport(page.getId(), (OutputStream)this.artifactStream);
        Path unzipped = this.unzip(this.artifactStream);
        byte[] actual = Files.readAllBytes(unzipped.resolve("resources/page.json"));
        byte[] expected = Files.readAllBytes(tmpDir.resolve(page.getId() + ".json"));
        Assertions.assertThat((byte[])actual).isEqualTo((Object)expected);
        FileUtils.deleteDirectory((File)unzipped.toFile());
    }

    @Test
    void should_execute_export_steps(@TempDir Path tmpDir) throws Exception {
        FakeStep fakeStep1 = new FakeStep("This is some content", "resources/file1.json");
        FakeStep fakeStep2 = new FakeStep("This is another content", "resources/deep/file2.json");
        PageExporter exporter = new PageExporter(this.jsonHandler, this.pageService, new ExportStep[]{fakeStep1, fakeStep2});
        Page page = this.create(PageBuilder.aPage().build(), tmpDir);
        exporter.handleFileExport(page.getId(), (OutputStream)this.artifactStream);
        Path unzipped = this.unzip(this.artifactStream);
        Assertions.assertThat((byte[])Files.readAllBytes(unzipped.resolve("resources/file1.json"))).isEqualTo((Object)"This is some content".getBytes());
        Assertions.assertThat((byte[])Files.readAllBytes(unzipped.resolve("resources/deep/file2.json"))).isEqualTo((Object)"This is another content".getBytes());
        FileUtils.deleteDirectory((File)unzipped.toFile());
    }

    private class FakeStep
    implements ExportStep<Page> {
        private String content;
        private String filename;

        public FakeStep(String content, String filename) {
            this.content = content;
            this.filename = filename;
        }

        public void execute(Zipper zipper, Page page) throws IOException {
            zipper.addToZip(this.content.getBytes(), this.filename);
        }
    }
}

