/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.export.properties;

import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.controller.export.properties.BonitaBusinessDataResourcePredicate;
import org.bonitasoft.web.designer.model.data.DataType;
import org.bonitasoft.web.designer.model.data.Variable;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class BonitaBusinessDataResourceResourcePredicateTest {
    private Variable variable;
    private BonitaBusinessDataResourcePredicate predicate;

    BonitaBusinessDataResourceResourcePredicateTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.variable = new Variable(DataType.BUSINESSDATA, "");
        this.predicate = new BonitaBusinessDataResourcePredicate();
    }

    @Test
    void should_return_true_when_variable_is_a_businessData() throws Exception {
        Assertions.assertThat((boolean)this.predicate.test(this.variable)).isTrue();
    }

    @Test
    void should_return_false_when_variable_is_not_a_businessData() throws Exception {
        this.variable.setType(DataType.URL);
        Assertions.assertThat((boolean)this.predicate.test(this.variable)).isFalse();
    }

    @Test
    void should_return_false_when_variable_value_is_empty() throws Exception {
        this.variable.setValue(null);
        Assertions.assertThat((boolean)this.predicate.test(this.variable)).isFalse();
    }
}

