/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.export.steps;

import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.common.export.Zipper;
import org.bonitasoft.web.designer.controller.export.properties.PagePropertiesBuilder;
import org.bonitasoft.web.designer.controller.export.steps.PagePropertiesExportStep;
import org.bonitasoft.web.designer.model.page.Page;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class PagePropertiesExportStepTest {
    @Mock
    private Zipper zipper;
    @Mock
    private PagePropertiesBuilder pagePropertiesBuilder;
    @InjectMocks
    private PagePropertiesExportStep step;

    PagePropertiesExportStepTest() {
    }

    @Test
    void should_add_page_properties_to_zip() throws Exception {
        Page page = PageBuilder.aPage().build();
        Mockito.when((Object)this.pagePropertiesBuilder.build(page)).thenReturn((Object)"foobar".getBytes());
        this.step.execute(this.zipper, page);
        ((Zipper)Mockito.verify((Object)this.zipper)).addToZip("foobar".getBytes(), "page.properties");
    }
}

