/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.export.steps;

import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import org.apache.commons.codec.digest.DigestUtils;
import org.bonitasoft.web.angularjs.export.Minifier;
import org.bonitasoft.web.angularjs.export.WidgetsExportStep;
import org.bonitasoft.web.angularjs.rendering.DirectiveFileGenerator;
import org.bonitasoft.web.designer.builder.ComponentBuilder;
import org.bonitasoft.web.designer.builder.ElementBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.builder.WidgetBuilder;
import org.bonitasoft.web.designer.common.export.Zipper;
import org.bonitasoft.web.designer.common.repository.FragmentRepository;
import org.bonitasoft.web.designer.common.visitor.WidgetIdVisitor;
import org.bonitasoft.web.designer.config.WorkspaceProperties;
import org.bonitasoft.web.designer.model.page.AbstractPage;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.utils.rule.TemporaryWidgetRepository;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
class WidgetsExportStepTest {
    @Mock
    private FragmentRepository fragmentRepository;
    private final WorkspaceProperties workspaceProperties = new WorkspaceProperties();
    public TemporaryWidgetRepository repository = new TemporaryWidgetRepository(this.workspaceProperties);
    private WidgetsExportStep step;
    @Mock
    private Zipper zipper;
    @Mock
    private DirectiveFileGenerator directiveFileGenerator;
    @TempDir
    Path tempDir;

    WidgetsExportStepTest() {
    }

    @BeforeEach
    void beforeEach() {
        this.step = new WidgetsExportStep(this.tempDir, new WidgetIdVisitor(this.fragmentRepository), this.directiveFileGenerator);
        this.zipper = (Zipper)Mockito.spy((Object)new Zipper((OutputStream)Mockito.mock(OutputStream.class)));
        try {
            this.repository.init(this.tempDir);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Test
    void should_add_page_widgets_to_zip() throws Exception {
        this.repository.addWidget(WidgetBuilder.aWidget().withId("widget1"));
        this.repository.addWidget(WidgetBuilder.aWidget().withId("widget2"));
        Page page = PageBuilder.aPage().with(new ElementBuilder[]{ComponentBuilder.aComponent((String)"widget1"), ComponentBuilder.aComponent((String)"widget2")}).build();
        String content = "Mon   content   to                 minify";
        byte[] expected = Minifier.minify((byte[])content.getBytes());
        Mockito.when((Object)this.directiveFileGenerator.getWidgetsFilesUsedInPage((Previewable)page)).thenReturn(Arrays.asList(Paths.get("widget1", new String[0]), Paths.get("widget2", new String[0])));
        Mockito.when((Object)this.directiveFileGenerator.concatenate(Arrays.asList(Paths.get("widget1", new String[0]), Paths.get("widget2", new String[0])))).thenReturn((Object)content.getBytes());
        this.step.execute(this.zipper, (AbstractPage)page);
        ((Zipper)Mockito.verify((Object)this.zipper)).addToZip(this.repository.resolveWidgetJson("widget1"), "resources/widgets/widget1/widget1.json");
        ((Zipper)Mockito.verify((Object)this.zipper)).addToZip(this.repository.resolveWidgetJson("widget2"), "resources/widgets/widget2/widget2.json");
        ((Zipper)Mockito.verify((Object)this.zipper)).addToZip(expected, "resources/js/widgets-" + DigestUtils.sha1Hex((byte[])expected) + ".min.js");
    }

    @Test
    void should_not_add_widget_metadata_to_zip() throws Exception {
        this.repository.addWidget(WidgetBuilder.aWidget().withId("widget"));
        Page page = PageBuilder.aPage().with(new ElementBuilder[]{ComponentBuilder.aComponent((String)"widget")}).build();
        String content = "content";
        Mockito.when((Object)this.directiveFileGenerator.getWidgetsFilesUsedInPage((Previewable)page)).thenReturn(Arrays.asList(Paths.get("widget", new String[0])));
        Mockito.when((Object)this.directiveFileGenerator.concatenate(Arrays.asList(Paths.get("widget", new String[0])))).thenReturn((Object)content.getBytes());
        this.step.execute(this.zipper, (AbstractPage)page);
        ((Zipper)Mockito.verify((Object)this.zipper, (VerificationMode)Mockito.never())).addToZip(this.repository.resolveWidgetMetadata("widget"), "resources/widgets/widget/widget.metadata.json");
    }
}

