/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.importer;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.ArtifactBuilder;
import org.bonitasoft.web.designer.DefaultArtifactBuilder;
import org.bonitasoft.web.designer.builder.ImportReportBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.builder.WidgetBuilder;
import org.bonitasoft.web.designer.common.generator.rendering.HtmlGenerator;
import org.bonitasoft.web.designer.controller.export.FragmentExporter;
import org.bonitasoft.web.designer.controller.export.PageExporter;
import org.bonitasoft.web.designer.controller.export.WidgetExporter;
import org.bonitasoft.web.designer.controller.importer.AbstractArtifactImporter;
import org.bonitasoft.web.designer.controller.importer.FragmentImporter;
import org.bonitasoft.web.designer.controller.importer.Import;
import org.bonitasoft.web.designer.controller.importer.ImportException;
import org.bonitasoft.web.designer.controller.importer.ImportStore;
import org.bonitasoft.web.designer.controller.importer.PageImporter;
import org.bonitasoft.web.designer.controller.importer.WidgetImporter;
import org.bonitasoft.web.designer.controller.importer.report.ImportReport;
import org.bonitasoft.web.designer.service.FragmentService;
import org.bonitasoft.web.designer.service.PageService;
import org.bonitasoft.web.designer.service.WidgetService;
import org.bonitasoft.web.designer.workspace.Workspace;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class PathImporterTest {
    private Path unzipedPath;
    @Mock
    private ImportStore importStore;
    private ArtifactBuilder artifactBuilder;
    private PageImporter pageImporter;
    private FragmentImporter fragmentImporter;
    private WidgetImporter widgetImporter;

    PathImporterTest() {
    }

    @BeforeEach
    void setUp(@TempDir Path tempDir) throws Exception {
        this.unzipedPath = Files.createDirectory(tempDir.resolve("unzipedPath"), new FileAttribute[0]);
        this.pageImporter = (PageImporter)Mockito.mock(PageImporter.class);
        this.fragmentImporter = (FragmentImporter)Mockito.mock(FragmentImporter.class);
        this.widgetImporter = (WidgetImporter)Mockito.mock(WidgetImporter.class);
        this.artifactBuilder = new DefaultArtifactBuilder((Workspace)Mockito.mock(Workspace.class), (WidgetService)Mockito.mock(WidgetService.class), (FragmentService)Mockito.mock(FragmentService.class), (PageService)Mockito.mock(PageService.class), (PageExporter)Mockito.mock(PageExporter.class), (FragmentExporter)Mockito.mock(FragmentExporter.class), (WidgetExporter)Mockito.mock(WidgetExporter.class), (HtmlGenerator)Mockito.mock(HtmlGenerator.class), this.importStore, this.pageImporter, this.fragmentImporter, this.widgetImporter);
    }

    private Import aMockedImport(AbstractArtifactImporter<?> importer) {
        Import anImport = new Import(importer, "import-uuid", this.unzipedPath);
        Mockito.when((Object)this.importStore.store(importer, this.unzipedPath)).thenReturn((Object)anImport);
        return anImport;
    }

    @Test
    void should_import_zip_file() throws Exception {
        ImportReport expectedReport = ImportReportBuilder.anImportReportFor(PageBuilder.aPage()).withStatus(ImportReport.Status.IMPORTED).build();
        Mockito.when((Object)this.pageImporter.tryToImportAndGenerateReport(this.aMockedImport((AbstractArtifactImporter<?>)this.pageImporter), false)).thenReturn((Object)expectedReport);
        ImportReport report = this.artifactBuilder.importPage(this.unzipedPath, false);
        Assertions.assertThat((Object)expectedReport).isEqualTo((Object)report);
    }

    @Test
    void should_remove_import_from_store_if_report_status_is_imported() throws Exception {
        Import anImport = this.aMockedImport((AbstractArtifactImporter<?>)this.pageImporter);
        Mockito.when((Object)this.pageImporter.tryToImportAndGenerateReport(anImport, false)).thenReturn((Object)ImportReportBuilder.anImportReportFor(PageBuilder.aPage()).withStatus(ImportReport.Status.IMPORTED).build());
        this.artifactBuilder.importPage(this.unzipedPath, false);
        ((ImportStore)Mockito.verify((Object)this.importStore)).remove(anImport.getUUID());
    }

    @Test
    void should_remove_import_from_store_if_an_error_occurs_when_importing() throws Exception {
        Import anImport = this.aMockedImport((AbstractArtifactImporter<?>)this.pageImporter);
        Mockito.when((Object)this.pageImporter.tryToImportAndGenerateReport(anImport, false)).thenThrow(ImportException.class);
        try {
            this.artifactBuilder.importPage(this.unzipedPath, false);
            Assertions.failBecauseExceptionWasNotThrown(ImportException.class);
        }
        catch (Exception e) {
            ((ImportStore)Mockito.verify((Object)this.importStore)).remove(anImport.getUUID());
        }
    }

    @Test
    void should_force_import_of_zip_file() throws Exception {
        Import anImport = this.aMockedImport((AbstractArtifactImporter<?>)this.widgetImporter);
        ImportReport expectedReport = ImportReportBuilder.anImportReportFor(WidgetBuilder.aWidget()).withStatus(ImportReport.Status.IMPORTED).build();
        Mockito.when((Object)this.widgetImporter.tryToImportAndGenerateReport(anImport, true)).thenReturn((Object)expectedReport);
        ImportReport report = this.artifactBuilder.importWidget(this.unzipedPath, true);
        Assertions.assertThat((Object)expectedReport).isEqualTo((Object)report);
        ((ImportStore)Mockito.verify((Object)this.importStore)).remove(anImport.getUUID());
    }

    @Test
    void should_throw_import_exception_when_an_import_error_occurs() throws Exception {
        Mockito.when((Object)this.importStore.store((AbstractArtifactImporter)this.fragmentImporter, this.unzipedPath)).thenReturn((Object)new Import((AbstractArtifactImporter)this.fragmentImporter, "a-uuid", this.unzipedPath));
        ((FragmentImporter)Mockito.doThrow((Throwable[])new Throwable[]{new ImportException(ImportException.Type.PAGE_NOT_FOUND, "an Error message")}).when((Object)this.fragmentImporter)).tryToImportAndGenerateReport((Import)Mockito.any(), ((Boolean)Mockito.any(Boolean.class)).booleanValue());
        org.junit.jupiter.api.Assertions.assertThrows(ImportException.class, () -> this.artifactBuilder.importFragment(this.unzipedPath, false));
    }
}

