/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.common.livebuild.Watcher;
import org.bonitasoft.web.designer.common.repository.JsonFileBasedLoader;
import org.bonitasoft.web.designer.common.repository.JsonFileBasedPersister;
import org.bonitasoft.web.designer.common.repository.PageRepository;
import org.bonitasoft.web.designer.common.repository.Repository;
import org.bonitasoft.web.designer.common.repository.WidgetFileBasedLoader;
import org.bonitasoft.web.designer.common.repository.WidgetRepository;
import org.bonitasoft.web.designer.migration.LiveRepositoryUpdate;
import org.bonitasoft.web.designer.migration.Migration;
import org.bonitasoft.web.designer.migration.MigrationStep;
import org.bonitasoft.web.designer.model.DesignerArtifact;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.JsonHandler;
import org.bonitasoft.web.designer.model.JsonHandlerFactory;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStatus;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.repository.BeanValidator;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
class LiveRepositoryUpdateTest {
    JsonHandler jsonHandler = new JsonHandlerFactory().create();
    @Mock
    JsonFileBasedPersister<Page> persister;
    JsonFileBasedLoader<Page> loader = new JsonFileBasedLoader(this.jsonHandler, Page.class);
    @Mock
    BeanValidator beanValidator;
    PageRepository repository;
    @TempDir
    Path folder;

    LiveRepositoryUpdateTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.repository = new PageRepository(this.folder, this.folder, this.persister, this.loader, this.beanValidator, (Watcher)Mockito.mock(Watcher.class));
    }

    @Test
    void should_migrate_a_page() throws Exception {
        MigrationStep mockMigrationStep = (MigrationStep)Mockito.mock(MigrationStep.class);
        Migration migration = new Migration("2.1", new MigrationStep[]{mockMigrationStep});
        LiveRepositoryUpdate liveRepositoryUpdate = new LiveRepositoryUpdate((Repository)this.repository, Collections.singletonList(migration));
        Page page = this.createPage("2.0");
        Optional<MigrationStepReport> stepReport = Optional.of(new MigrationStepReport(MigrationStatus.SUCCESS, "pageJson"));
        Mockito.when((Object)mockMigrationStep.migrate((Object)page)).thenReturn(stepReport);
        liveRepositoryUpdate.migrate();
        page.setModelVersion("2.1");
        ((JsonFileBasedPersister)Mockito.verify(this.persister)).save(this.folder.resolve("pageJson"), (Identifiable)page);
    }

    @Test
    void should_not_migrate_file_which_are_not_json() throws Exception {
        Migration migration = (Migration)Mockito.mock(Migration.class);
        LiveRepositoryUpdate liveRepositoryUpdate = new LiveRepositoryUpdate((Repository)this.repository, Collections.singletonList(migration));
        Files.createFile(this.folder.resolve("whatever"), new FileAttribute[0]);
        liveRepositoryUpdate.migrate();
        ((Migration)Mockito.verify((Object)migration, (VerificationMode)Mockito.never())).migrate((DesignerArtifact)((Page)ArgumentMatchers.any(Page.class)));
    }

    @Test
    void should_not_save_an_artifact_already_migrated() throws Exception {
        Migration migration = new Migration("1.0.2", new MigrationStep[]{(MigrationStep)Mockito.mock(MigrationStep.class)});
        LiveRepositoryUpdate liveRepositoryUpdate = new LiveRepositoryUpdate((Repository)this.repository, Collections.singletonList(migration));
        this.createPage("1.0.2");
        liveRepositoryUpdate.migrate();
        ((JsonFileBasedPersister)Mockito.verify(this.persister, (VerificationMode)Mockito.never())).save((Path)ArgumentMatchers.any(Path.class), (Identifiable)((Page)ArgumentMatchers.any(Page.class)));
    }

    @Test
    void should_exclude_assets() throws Exception {
        Migration migration = (Migration)Mockito.mock(Migration.class);
        LiveRepositoryUpdate liveRepositoryUpdate = new LiveRepositoryUpdate((Repository)this.repository, Collections.singletonList(migration));
        this.createPage("1.0.0");
        Path pageFolder = Files.createDirectory(this.folder.resolve("pageJson").resolve("assets"), new FileAttribute[0]);
        Files.createFile(pageFolder.resolve("whatever.json"), new FileAttribute[0]);
        liveRepositoryUpdate.migrate();
        ((Migration)Mockito.verify((Object)migration, (VerificationMode)Mockito.only())).migrate((DesignerArtifact)((Page)ArgumentMatchers.any(Page.class)));
    }

    @Test
    void should_be_refresh_repository_index_json_on_start() throws Exception {
        LiveRepositoryUpdate liveRepositoryUpdate = new LiveRepositoryUpdate((Repository)this.repository, Collections.EMPTY_LIST);
        this.createPage("1.7.25");
        liveRepositoryUpdate.start();
        ((JsonFileBasedPersister)Mockito.verify(this.persister)).saveInIndex((Path)Mockito.nullable(Path.class), (Identifiable)((Page)ArgumentMatchers.any(Page.class)));
        ((JsonFileBasedPersister)Mockito.verify(this.persister)).updateMetadata((Path)ArgumentMatchers.any(Path.class), (Identifiable)((Page)ArgumentMatchers.any(Page.class)));
    }

    @Test
    void should_order_LiveRepositoryUpdate() {
        LiveRepositoryUpdate pageLiveRepositoryUpdate = new LiveRepositoryUpdate((Repository)this.repository, Collections.EMPTY_LIST);
        WidgetRepository wRepo = new WidgetRepository(this.folder, this.folder, (JsonFileBasedPersister)Mockito.mock(JsonFileBasedPersister.class), (JsonFileBasedLoader)Mockito.mock(WidgetFileBasedLoader.class), this.beanValidator, (Watcher)Mockito.mock(Watcher.class));
        LiveRepositoryUpdate widgetLiveRepositoryUpdate = new LiveRepositoryUpdate((Repository)wRepo, Collections.EMPTY_LIST);
        ArrayList<LiveRepositoryUpdate> liveRepoList = new ArrayList<LiveRepositoryUpdate>();
        liveRepoList.add(pageLiveRepositoryUpdate);
        liveRepoList.add(widgetLiveRepositoryUpdate);
        Assertions.assertThat(liveRepoList).containsExactly((Object[])new LiveRepositoryUpdate[]{pageLiveRepositoryUpdate, widgetLiveRepositoryUpdate});
        Assertions.assertThat(liveRepoList.stream().sorted().collect(Collectors.toList())).containsExactly((Object[])new LiveRepositoryUpdate[]{widgetLiveRepositoryUpdate, pageLiveRepositoryUpdate});
    }

    private Page createPage(String version) throws IOException {
        Path pageJson = Files.createDirectory(this.folder.resolve("pageJson"), new FileAttribute[0]);
        Path descriptor = Files.createFile(pageJson.resolve("pageJson.json"), new FileAttribute[0]);
        Files.write(descriptor, String.format("{ \"id\": \"pageJson\", \"modelVersion\": \"%s\" }", version).getBytes(), new OpenOption[0]);
        return (Page)this.loader.load(descriptor);
    }
}

