/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration.page;

import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.ComponentBuilder;
import org.bonitasoft.web.designer.builder.ContainerBuilder;
import org.bonitasoft.web.designer.builder.ElementBuilder;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.builder.FragmentElementBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.builder.PropertyBuilder;
import org.bonitasoft.web.designer.builder.WidgetBuilder;
import org.bonitasoft.web.designer.common.repository.FragmentRepository;
import org.bonitasoft.web.designer.common.repository.WidgetRepository;
import org.bonitasoft.web.designer.migration.page.BondMigrationStep;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.page.AbstractPage;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.Container;
import org.bonitasoft.web.designer.model.page.Element;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.page.PropertyValue;
import org.bonitasoft.web.designer.model.widget.BondType;
import org.bonitasoft.web.designer.model.widget.Property;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.visitor.ComponentVisitor;
import org.bonitasoft.web.designer.visitor.VisitorFactory;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class BondMigrationStepTest {
    @Mock
    WidgetRepository widgetRepository;
    @Mock
    private FragmentRepository fragmentRepository;
    BondMigrationStep bondMigrationStep;
    Component component = (Component)ComponentBuilder.aComponent().withWidgetId("widgetId").withPropertyValue("foo", "data", (Object)"bar").build();
    Container container = (Container)ContainerBuilder.aContainer().with(new Element[]{this.component}).withPropertyValue("foo", "data", (Object)"bar").build();
    Page page = PageBuilder.aPage().with(new Element[]{this.container}).build();
    Property property = PropertyBuilder.aProperty().name("foo").build();

    BondMigrationStepTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.bondMigrationStep = new BondMigrationStep(new ComponentVisitor(this.fragmentRepository), this.widgetRepository, new VisitorFactory());
        Mockito.when((Object)((Widget)this.widgetRepository.get("widgetId"))).thenReturn((Object)WidgetBuilder.aWidget().property(this.property).build());
    }

    @Test
    void should_migrate_constant_property() throws Exception {
        this.property.setBond(BondType.CONSTANT);
        this.property.setDefaultValue((Object)"baz");
        this.bondMigrationStep.migrate((AbstractPage)this.page);
        PropertyValue foo = (PropertyValue)this.component.getPropertyValues().get("foo");
        Assertions.assertThat((String)foo.getType()).isEqualTo("constant");
        Assertions.assertThat((Object)foo.getValue()).isEqualTo((Object)"baz");
    }

    @Test
    void should_migrate_interpolated_property() throws Exception {
        this.property.setBond(BondType.INTERPOLATION);
        this.bondMigrationStep.migrate((AbstractPage)this.page);
        PropertyValue foo = (PropertyValue)this.component.getPropertyValues().get("foo");
        Assertions.assertThat((String)foo.getType()).isEqualTo("interpolation");
        Assertions.assertThat((Object)foo.getValue()).isEqualTo((Object)"{{bar}}");
    }

    @Test
    void should_migrate_expression_property() throws Exception {
        this.property.setBond(BondType.EXPRESSION);
        this.bondMigrationStep.migrate((AbstractPage)this.page);
        PropertyValue foo = (PropertyValue)this.component.getPropertyValues().get("foo");
        Assertions.assertThat((String)foo.getType()).isEqualTo("expression");
        Assertions.assertThat((Object)foo.getValue()).isEqualTo((Object)"bar");
    }

    @Test
    void should_migrate_variable_property() throws Exception {
        this.property.setBond(BondType.VARIABLE);
        this.bondMigrationStep.migrate((AbstractPage)this.page);
        PropertyValue foo = (PropertyValue)this.component.getPropertyValues().get("foo");
        Assertions.assertThat((String)foo.getType()).isEqualTo("variable");
        Assertions.assertThat((Object)foo.getValue()).isEqualTo((Object)"bar");
    }

    @Test
    void should_migrate_a_container_properties() throws Exception {
        this.property.setBond(BondType.VARIABLE);
        this.bondMigrationStep.migrate((AbstractPage)this.page);
        PropertyValue foo = (PropertyValue)this.container.getPropertyValues().get("foo");
        Assertions.assertThat((String)foo.getType()).isEqualTo("expression");
        Assertions.assertThat((Object)foo.getValue()).isEqualTo((Object)"bar");
    }

    @Test
    void should_migrate_a_page_containing_a_fragment() throws Exception {
        this.property.setBond(BondType.CONSTANT);
        this.property.setDefaultValue((Object)"baz");
        Page page = PageBuilder.aPage().with(new ElementBuilder[]{FragmentElementBuilder.aFragmentElement().withFragmentId("aFragment")}).with(new Element[]{this.component}).build();
        Mockito.when((Object)((Fragment)this.fragmentRepository.get("aFragment"))).thenReturn((Object)FragmentBuilder.aFragment().build());
        this.bondMigrationStep.migrate((AbstractPage)page);
        PropertyValue foo = (PropertyValue)this.component.getPropertyValues().get("foo");
        Assertions.assertThat((String)foo.getType()).isEqualTo("constant");
        Assertions.assertThat((Object)foo.getValue()).isEqualTo((Object)"baz");
    }

    @Test
    void should_migrate_a_fragment() throws Exception {
        this.property.setBond(BondType.CONSTANT);
        this.property.setDefaultValue((Object)"baz");
        Fragment fragment = FragmentBuilder.aFragment().with(new ElementBuilder[]{FragmentElementBuilder.aFragmentElement().withFragmentId("aFragment")}).with(new Element[]{this.component}).build();
        Mockito.when((Object)((Fragment)this.fragmentRepository.get("aFragment"))).thenReturn((Object)FragmentBuilder.aFragment().build());
        this.bondMigrationStep.migrate((AbstractPage)fragment);
        PropertyValue foo = (PropertyValue)this.component.getPropertyValues().get("foo");
        Assertions.assertThat((String)foo.getType()).isEqualTo("constant");
        Assertions.assertThat((Object)foo.getValue()).isEqualTo((Object)"baz");
    }
}

