/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration.page;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.builder.VariableBuilder;
import org.bonitasoft.web.designer.migration.page.BusinessVariableMigrationStep;
import org.bonitasoft.web.designer.model.data.Variable;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.page.AbstractPage;
import org.bonitasoft.web.designer.model.page.Page;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class BusinessVariableMigrationStepTest {
    BusinessVariableMigrationStep<AbstractPage> businessVariableMigrationStep;

    BusinessVariableMigrationStepTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.businessVariableMigrationStep = new BusinessVariableMigrationStep();
    }

    @Test
    void should_migrate_page_with_business_data() throws Exception {
        String businessDataValue = "{\"businessObjectName\":\"BusinessObject1\",\"id\":\"com_company_model_BusinessObject1\",\"filters\":[],\"pagination\":{\"p\":0,\"c\":10}}";
        String expectedValue = "{\"businessObjectName\":\"BusinessObject1\",\"id\":\"com.company.model.BusinessObject1\",\"filters\":[],\"pagination\":{\"p\":\"0\",\"c\":\"10\"}}";
        Page pageWithData = PageBuilder.aPage().withId("pageWithData").withVariable("aBusinessData", VariableBuilder.aBusinessDataVariable().value(businessDataValue).build()).build();
        this.businessVariableMigrationStep.migrate((AbstractPage)pageWithData);
        Assertions.assertThat((List)((Variable)pageWithData.getVariables().get("aBusinessData")).getValue()).isEqualTo(Arrays.asList(expectedValue));
    }

    @Test
    void should_migrate_fragment_with_business_data() throws Exception {
        String businessDataValue = "{\"businessObjectName\":\"BusinessObject1\",\"id\":\"com_company_model_BusinessObject1\",\"filters\":[],\"pagination\":{\"p\":0,\"c\":10}}";
        String expectedValue = "{\"businessObjectName\":\"BusinessObject1\",\"id\":\"com.company.model.BusinessObject1\",\"filters\":[],\"pagination\":{\"p\":\"0\",\"c\":\"10\"}}";
        Fragment fragmentWithData = FragmentBuilder.aFragment().withId("fragmentWithData").withVariable("aBusinessData", VariableBuilder.aBusinessDataVariable().value(businessDataValue).build()).build();
        this.businessVariableMigrationStep.migrate((AbstractPage)fragmentWithData);
        Assertions.assertThat((List)((Variable)fragmentWithData.getVariables().get("aBusinessData")).getValue()).isEqualTo(Arrays.asList(expectedValue));
    }
}

