/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.service;

import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.bonitasoft.web.designer.builder.AssetBuilder;
import org.bonitasoft.web.designer.builder.ComponentBuilder;
import org.bonitasoft.web.designer.builder.ElementBuilder;
import org.bonitasoft.web.designer.builder.FragmentBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.builder.PropertyBuilder;
import org.bonitasoft.web.designer.builder.WidgetBuilder;
import org.bonitasoft.web.designer.common.repository.FragmentRepository;
import org.bonitasoft.web.designer.common.repository.PageRepository;
import org.bonitasoft.web.designer.common.repository.WidgetRepository;
import org.bonitasoft.web.designer.common.repository.exception.InUseException;
import org.bonitasoft.web.designer.common.repository.exception.NotAllowedException;
import org.bonitasoft.web.designer.common.repository.exception.RepositoryException;
import org.bonitasoft.web.designer.common.visitor.AssetVisitor;
import org.bonitasoft.web.designer.common.visitor.WidgetIdVisitor;
import org.bonitasoft.web.designer.config.UiDesignerProperties;
import org.bonitasoft.web.designer.controller.asset.AssetService;
import org.bonitasoft.web.designer.model.ArtifactStatusReport;
import org.bonitasoft.web.designer.model.Assetable;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.asset.AssetType;
import org.bonitasoft.web.designer.model.exception.NotFoundException;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.migrationReport.MigrationResult;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStatus;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.model.widget.BondType;
import org.bonitasoft.web.designer.model.widget.Property;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.service.BondsTypesFixer;
import org.bonitasoft.web.designer.service.DefaultWidgetService;
import org.bonitasoft.web.designer.service.WidgetMigrationApplyer;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
class WidgetServiceTest {
    private static final String CURRENT_MODEL_VERSION = "2.0";
    @Mock
    private WidgetRepository widgetRepository;
    @Mock
    private PageRepository pageRepository;
    @Mock
    private FragmentRepository fragmentRepository;
    @Mock
    private BondsTypesFixer<?> bondsTypesFixer;
    @Mock
    private WidgetMigrationApplyer widgetMigrationApplyer;
    @Mock
    private WidgetIdVisitor widgetIdVisitor;
    @Mock
    private AssetService<Widget> widgetAssetService;
    @InjectMocks
    private DefaultWidgetService widgetService;
    private ArtifactStatusReport artifactStatusReport;
    UiDesignerProperties uiDesignerProperties;

    WidgetServiceTest() {
    }

    @BeforeEach
    void setUp() {
        AssetVisitor assetVisitor = new AssetVisitor(this.widgetRepository, this.fragmentRepository);
        this.uiDesignerProperties = new UiDesignerProperties("1.13.0", CURRENT_MODEL_VERSION);
        this.uiDesignerProperties.getWorkspace().getWidgets().setDir(Paths.get("Widget", new String[0]));
        this.widgetService = (DefaultWidgetService)Mockito.spy((Object)new DefaultWidgetService(this.widgetRepository, this.pageRepository, this.fragmentRepository, Collections.singletonList(this.bondsTypesFixer), this.widgetMigrationApplyer, this.widgetIdVisitor, assetVisitor, this.uiDesignerProperties, this.widgetAssetService));
        this.artifactStatusReport = new ArtifactStatusReport(true, false);
    }

    @Test
    void should_serve_all_widgets_in_repository() {
        Widget input = WidgetBuilder.aWidget().withId("input").build();
        Widget label = WidgetBuilder.aWidget().withId("label").build();
        List<Widget> expectedWidgetList = Arrays.asList(input, label);
        Mockito.when((Object)this.widgetRepository.getAll()).thenReturn(expectedWidgetList);
        List widgets = this.widgetService.getAll();
        ((ListAssert)((ListAssert)Assertions.assertThat((List)widgets).hasSameSizeAs(expectedWidgetList)).contains((Object[])new Widget[]{input})).contains((Object[])new Widget[]{label});
    }

    @Test
    void should_serve_empty_list_if_widget_repository_is_empty() {
        Mockito.when((Object)this.widgetRepository.getAll()).thenReturn(Collections.emptyList());
        List widgets = this.widgetService.getAll();
        Assertions.assertThat((List)widgets).isEmpty();
    }

    @Test
    void should_throw_repo_exception_if_an_error_occurs_while_getting_widgets() {
        Mockito.when((Object)this.widgetRepository.getAll()).thenThrow(new Throwable[]{new RepositoryException("error occurs", (Throwable)new Exception())});
        Assertions.assertThatThrownBy(() -> this.widgetService.getAll()).isInstanceOf(RepositoryException.class);
    }

    @Test
    void should_get_a_widget_by_its_id() {
        String widgetId = "input";
        Widget input = WidgetBuilder.aWidget().withId(widgetId).build();
        ((DefaultWidgetService)Mockito.doReturn((Object)this.artifactStatusReport).when((Object)this.widgetService)).getStatus((Identifiable)((Widget)ArgumentMatchers.any()));
        Mockito.when((Object)((Widget)this.widgetRepository.get(widgetId))).thenReturn((Object)input);
        Mockito.when((Object)this.widgetService.migrate(input)).thenReturn((Object)input);
        Widget widget = this.widgetService.get(widgetId);
        Assertions.assertThat((Object)widget).isEqualTo((Object)input);
        Assertions.assertThat((Collection)widget.getAssets()).isEmpty();
    }

    @Test
    void should_get_a_widget_with_asset_by_its_id() {
        String widgetId = "input";
        Widget input = WidgetBuilder.aWidget().withId(widgetId).assets(new AssetBuilder[]{AssetBuilder.anAsset().withName("myScopeWidgetAsset").withType(AssetType.CSS)}).build();
        ((DefaultWidgetService)Mockito.doReturn((Object)this.artifactStatusReport).when((Object)this.widgetService)).getStatus((Identifiable)((Widget)ArgumentMatchers.any()));
        Mockito.when((Object)((Widget)this.widgetRepository.get(widgetId))).thenReturn((Object)input);
        Mockito.when((Object)this.widgetService.migrate(input)).thenReturn((Object)input);
        Widget widget = this.widgetService.getWithAsset(widgetId);
        Assertions.assertThat((Object)widget).isEqualTo((Object)input);
        Assertions.assertThat((Collection)widget.getAssets()).hasSize(1);
        Assertions.assertThat((String)((Asset)widget.getAssets().stream().findFirst().get()).getScope()).isEqualTo("widget");
    }

    @Test
    void should_throw_NotFoundException_when_getting_an_unexisting_widget() {
        Mockito.when((Object)((Widget)this.widgetRepository.get("notExistingWidget"))).thenThrow(new Throwable[]{new NotFoundException("not found")});
        Assertions.assertThatThrownBy(() -> this.widgetService.getWithAsset("notExistingWidget")).isInstanceOf(NotFoundException.class);
    }

    @Test
    void should_save_a_widget() {
        Widget customLabel = WidgetBuilder.aWidget().withId("customLabel").custom().build();
        this.widgetService.save("customLabel", customLabel);
        ((WidgetRepository)Mockito.verify((Object)this.widgetRepository)).updateLastUpdateAndSave((Identifiable)customLabel);
    }

    @Test
    void should_not_allow_to_save_a_pb_widget() {
        Widget pbWidget = WidgetBuilder.aWidget().custom().build();
        Assertions.assertThatThrownBy(() -> this.widgetService.save("pbLabel", pbWidget)).isInstanceOf(NotAllowedException.class);
    }

    @Test
    void should_not_allow_to_save_a_not_custom_widget() {
        Widget pbWidget = WidgetBuilder.aWidget().withId("input").build();
        Assertions.assertThatThrownBy(() -> this.widgetService.save("customLabel", pbWidget)).isInstanceOf(NotAllowedException.class);
    }

    @Test
    void should_throw_RepositoryException_if_an_error_occurs_while_saving_a_widget() {
        Widget customLabel = WidgetBuilder.aWidget().withId("customLabel").custom().build();
        ((WidgetRepository)Mockito.doThrow((Throwable[])new Throwable[]{new RepositoryException("error occurs", (Throwable)new Exception())}).when((Object)this.widgetRepository)).updateLastUpdateAndSave((Identifiable)customLabel);
        Assertions.assertThatThrownBy(() -> this.widgetService.save("customLabel", customLabel)).isInstanceOf(RepositoryException.class);
    }

    @Test
    void should_create_a_new_widget() {
        Widget customLabel = WidgetBuilder.aWidget().withName("label").custom().build();
        Mockito.when((Object)this.widgetRepository.create(customLabel)).thenReturn((Object)customLabel);
        this.widgetService.create(customLabel);
        ((WidgetRepository)Mockito.verify((Object)this.widgetRepository)).create((Widget)ArgumentMatchers.notNull());
    }

    @Test
    void should_duplicate_a_widget_from_a_widget() {
        Widget customLabel = WidgetBuilder.aWidget().withName("label").assets(new AssetBuilder[]{AssetBuilder.anAsset().withName("myfile.js")}).custom().build();
        String sourceWidgetId = "my-widget-source";
        Mockito.when((Object)this.widgetRepository.create(customLabel)).thenReturn((Object)customLabel);
        Path sourceWidgetPath = Paths.get("my-widget-source", new String[0]);
        Mockito.when((Object)this.widgetRepository.resolvePath(sourceWidgetId)).thenReturn((Object)sourceWidgetPath);
        Widget savedWidget = this.widgetService.createFrom(sourceWidgetId, customLabel);
        ((WidgetRepository)Mockito.verify((Object)this.widgetRepository)).create(customLabel);
        ((AssetService)Mockito.verify(this.widgetAssetService)).duplicateAsset(this.uiDesignerProperties.getWorkspace().getWidgets().getDir(), sourceWidgetPath, sourceWidgetId, customLabel.getId());
        Assertions.assertThat((Object)savedWidget).isEqualTo((Object)customLabel);
    }

    @Test
    void should_not_allow_to_create_a_widget_with_an_empty_name() {
        Widget customLabel = WidgetBuilder.aWidget().withName("").custom().build();
        Mockito.when((Object)this.widgetRepository.create(customLabel)).thenThrow(new Throwable[]{new IllegalArgumentException()});
        Assertions.assertThatThrownBy(() -> this.widgetService.create(customLabel)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void should_not_allow_to_create_a_widget_with_an_existing_name() {
        Widget customLabel = WidgetBuilder.aWidget().withName("alreadyExistingName").build();
        Mockito.when((Object)this.widgetRepository.create(customLabel)).thenThrow(new Throwable[]{new NotAllowedException("already existing name")});
        Assertions.assertThatThrownBy(() -> this.widgetService.create(customLabel)).isInstanceOf(NotAllowedException.class);
    }

    @Test
    void should_delete_a_widget() {
        Widget customLabel = WidgetBuilder.aWidget().custom().withId("customLabel").build();
        Mockito.when((Object)((Widget)this.widgetRepository.get("customLabel"))).thenReturn((Object)customLabel);
        Mockito.when((Object)this.fragmentRepository.getArtifactsUsingWidget(customLabel.getId())).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.pageRepository.getArtifactsUsingWidget(customLabel.getId())).thenReturn(Collections.emptyList());
        this.widgetService.delete("customLabel");
        ((WidgetRepository)Mockito.verify((Object)this.widgetRepository)).delete("customLabel");
    }

    @Test
    void should_not_allow_to_delete_a_pb_widget() {
        Mockito.when((Object)((Widget)this.widgetRepository.get("pbWidget"))).thenReturn((Object)WidgetBuilder.aWidget().withId("pbWidget").build());
        Assertions.assertThatThrownBy(() -> this.widgetService.delete("pbWidget")).isInstanceOf(NotAllowedException.class);
    }

    @Test
    void should_throw_NotFoundException_if_trying_to_delete_an_unknown_widget() {
        ((WidgetRepository)Mockito.doThrow((Throwable[])new Throwable[]{new NotFoundException("not found")}).when((Object)this.widgetRepository)).get("customLabel");
        Assertions.assertThatThrownBy(() -> this.widgetService.delete("customLabel")).isInstanceOf(NotFoundException.class);
    }

    @Test
    void should_not_allow_to_delete_a_custom_widget_used_in_a_page() {
        Mockito.when((Object)((Widget)this.widgetRepository.get("customLabel"))).thenReturn((Object)WidgetBuilder.aWidget().custom().withId("customLabel").build());
        Mockito.when((Object)this.pageRepository.getComponentName()).thenReturn((Object)"page");
        Mockito.when((Object)this.pageRepository.getArtifactsUsingWidget("customLabel")).thenReturn(Collections.singletonList(PageBuilder.aPage().withName("person").build()));
        Mockito.when((Object)this.fragmentRepository.getComponentName()).thenReturn((Object)"fragment");
        Mockito.when((Object)this.fragmentRepository.getArtifactsUsingWidget("customLabel")).thenReturn(Arrays.asList(FragmentBuilder.aFragment().withName("personFragment1").build(), FragmentBuilder.aFragment().withName("personFragment2").build()));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.widgetService.delete("customLabel")).isInstanceOf(InUseException.class)).hasMessage("The widget cannot be deleted because it is used in 2 fragments, <personFragment1>, <personFragment2> 1 page, <person>");
    }

    @Test
    void should_throw_not_found_if_custom_widget_is_not_existing_when_renaming() {
        Property requestProperty = new PropertyBuilder().name("hello").build();
        Mockito.when((Object)this.widgetRepository.updateProperty("my-widget", "name", requestProperty)).thenThrow(new Throwable[]{new NotFoundException("page not found")});
        Assertions.assertThatThrownBy(() -> this.widgetService.updateProperty("my-widget", "name", requestProperty)).isInstanceOf(NotFoundException.class);
    }

    @Test
    void should_add_a_property_to_a_widget_and_return_the_list_of_properties() {
        Property property = PropertyBuilder.aProperty().build();
        List<Property> expectedProperties = Collections.singletonList(property);
        Mockito.when((Object)this.widgetRepository.addProperty("customLabel", property)).thenReturn(expectedProperties);
        this.widgetService.addProperty("customLabel", property);
        ((WidgetRepository)Mockito.verify((Object)this.widgetRepository)).addProperty("customLabel", property);
    }

    @Test
    void should_not_allow_to_add_a_property_to_a_pb_widget() {
        Property property = PropertyBuilder.aProperty().build();
        Assertions.assertThatThrownBy(() -> this.widgetService.addProperty("pbLabel", property)).isInstanceOf(NotAllowedException.class);
    }

    @Test
    void should_throw_NotFoundException_when_adding_a_property_to_an_unexisting_widget() {
        Mockito.when((Object)this.widgetRepository.addProperty((String)ArgumentMatchers.eq((Object)"unknownWidget"), (Property)ArgumentMatchers.any(Property.class))).thenThrow(new Throwable[]{new NotFoundException("not found")});
        Property property = PropertyBuilder.aProperty().build();
        Assertions.assertThatThrownBy(() -> this.widgetService.addProperty("unknownWidget", property)).isInstanceOf(NotFoundException.class);
    }

    @Test
    void should_throw_RepositoryException_when_error_appear_while_saving_property() {
        Mockito.when((Object)this.widgetRepository.addProperty((String)ArgumentMatchers.eq((Object)"label"), (Property)ArgumentMatchers.any(Property.class))).thenThrow(RepositoryException.class);
        Property property = PropertyBuilder.aProperty().build();
        Assertions.assertThatThrownBy(() -> this.widgetService.addProperty("label", property)).isInstanceOf(RepositoryException.class);
    }

    @Test
    void should_update_a_property_of_a_widget_and_return_the_list_of_properties() {
        Property property = PropertyBuilder.aProperty().build();
        List<Property> expectedProperties = Collections.singletonList(property);
        Mockito.when((Object)this.widgetRepository.updateProperty("customLabel", "toBeUpdated", property)).thenReturn(expectedProperties);
        this.widgetService.updateProperty("customLabel", "toBeUpdated", property);
        ((WidgetRepository)Mockito.verify((Object)this.widgetRepository)).updateProperty("customLabel", "toBeUpdated", property);
    }

    @Test
    void should_not_allow_to_update_a_property_of_a_pb_widget() {
        Property property = PropertyBuilder.aProperty().build();
        Assertions.assertThatThrownBy(() -> this.widgetService.updateProperty("pbLabel", "toBeUpdated", property)).isInstanceOf(NotAllowedException.class);
    }

    @Test
    void should_throw_NotFoundException_when_widget_or_property_not_found_while_updating_property() {
        Property property = PropertyBuilder.aProperty().build();
        Assertions.assertThatThrownBy(() -> this.widgetService.updateProperty("pbLabel", "toBeUpdated", property)).isInstanceOf(NotAllowedException.class);
    }

    @Test
    void should_throw_RepositoryException_when_error_appear_while_updating_property() {
        Mockito.when((Object)this.widgetRepository.updateProperty((String)ArgumentMatchers.eq((Object)"label"), (String)ArgumentMatchers.eq((Object)"toBeUpdated"), (Property)ArgumentMatchers.any(Property.class))).thenThrow(RepositoryException.class);
        Property property = PropertyBuilder.aProperty().build();
        Assertions.assertThatThrownBy(() -> this.widgetService.updateProperty("label", "toBeUpdated", property)).isInstanceOf(RepositoryException.class);
    }

    @Test
    void should_delete_a_property_of_a_widget_and_return_the_list_of_properties() {
        Property property = PropertyBuilder.aProperty().build();
        List<Property> expectedProperties = Collections.singletonList(property);
        Mockito.when((Object)this.widgetRepository.deleteProperty("customLabel", "toBeDeleted")).thenReturn(expectedProperties);
        this.widgetService.deleteProperty("customLabel", "toBeDeleted");
        ((WidgetRepository)Mockito.verify((Object)this.widgetRepository)).deleteProperty("customLabel", "toBeDeleted");
    }

    @Test
    void should_not_allow_to_delete_a_property_of_a_pb_widget() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.widgetService.deleteProperty("pbLabel", "toBeDeleted")).isInstanceOf(NotAllowedException.class)).hasMessage("Not allowed to modify a non custom widgets");
    }

    @Test
    void should_throw_NotFoundException_when_widget_or_property_not_found_while_deleting_property() {
        Mockito.when((Object)this.widgetRepository.deleteProperty("label", "toBeDeleted")).thenThrow(new Throwable[]{new NotFoundException("Widget [ toBeDeleted ] not found")});
        Assertions.assertThatThrownBy(() -> this.widgetService.deleteProperty("label", "toBeDeleted")).isInstanceOf(NotFoundException.class);
    }

    @Test
    void should_respond_500_when_error_appear_while_deleting_property() {
        Mockito.when((Object)this.widgetRepository.deleteProperty("label", "toBeDeleted")).thenThrow(RepositoryException.class);
        Assertions.assertThatThrownBy(() -> this.widgetService.deleteProperty("label", "toBeDeleted")).isInstanceOf(RepositoryException.class);
    }

    @Test
    void should_save_a_local_asset() {
        byte[] fileContent = "var hello = 'hello';".getBytes(StandardCharsets.UTF_8);
        Widget widget = WidgetBuilder.aWidget().withId("my-widget").custom().build();
        Mockito.when((Object)((Widget)this.widgetRepository.get("my-widget"))).thenReturn((Object)widget);
        String assetGeneratedId = "assetId";
        Mockito.when((Object)this.widgetAssetService.save((Assetable)((Widget)ArgumentMatchers.eq((Object)widget)), (Asset)ArgumentMatchers.any(), (byte[])ArgumentMatchers.eq((Object)fileContent))).thenAnswer(invocationOnMock -> {
            Asset assetToSave = (Asset)invocationOnMock.getArgument(1);
            Assertions.assertThat((String)assetToSave.getId()).isNull();
            assetToSave.setId(assetGeneratedId);
            return assetToSave;
        });
        ((DefaultWidgetService)Mockito.doReturn((Object)this.artifactStatusReport).when((Object)this.widgetService)).getStatus((Identifiable)((Widget)ArgumentMatchers.any()));
        Asset savedAsset = this.widgetService.saveOrUpdateAsset("my-widget", AssetType.JAVASCRIPT, "myfile.js", fileContent);
        Assertions.assertThat((String)savedAsset.getId()).isEqualTo(assetGeneratedId);
        ArgumentCaptor assetCaptor = ArgumentCaptor.forClass(Asset.class);
        ((AssetService)Mockito.verify(this.widgetAssetService)).save((Assetable)((Widget)ArgumentMatchers.eq((Object)widget)), (Asset)assetCaptor.capture(), (byte[])ArgumentMatchers.eq((Object)fileContent));
        Asset assetToSave = (Asset)assetCaptor.getValue();
        Assertions.assertThat((String)assetToSave.getName()).isEqualTo("myfile.js");
        Assertions.assertThat((Comparable)assetToSave.getType()).isEqualTo((Object)AssetType.JAVASCRIPT);
        Assertions.assertThat((int)assetToSave.getOrder()).isEqualTo(1);
    }

    @Test
    void should_not_upload_an_asset_for_internal_widget() {
        byte[] bytes = "foo".getBytes();
        Assertions.assertThatThrownBy(() -> this.widgetService.saveOrUpdateAsset("pbwidget", AssetType.JAVASCRIPT, "myfile.js", bytes)).isInstanceOf(NotAllowedException.class);
    }

    @Test
    void should_save_an_external_asset() {
        Widget widget = WidgetBuilder.aWidget().withId("my-widget").custom().build();
        Asset expectedAsset = AssetBuilder.anAsset().withId("assetId").active().withName("myfile.js").withOrder(2).withType(AssetType.JAVASCRIPT).build();
        ((DefaultWidgetService)Mockito.doReturn((Object)this.artifactStatusReport).when((Object)this.widgetService)).getStatus((Identifiable)((Widget)ArgumentMatchers.any()));
        Mockito.when((Object)((Widget)this.widgetRepository.get("my-widget"))).thenReturn((Object)widget);
        Mockito.when((Object)this.widgetService.migrate(widget)).thenReturn((Object)widget);
        this.widgetService.saveAsset("my-widget", expectedAsset);
        ((AssetService)Mockito.verify(this.widgetAssetService)).save((Assetable)widget, expectedAsset);
    }

    @Test
    void should_not_save_an_external_asset_for_internal_widget() {
        Asset asset = AssetBuilder.anAsset().build();
        Assertions.assertThatThrownBy(() -> this.widgetService.saveAsset("pb-widget", asset)).isInstanceOf(NotAllowedException.class);
    }

    @Test
    void should_not_save_an_external_asset_when_upload_send_an_error() {
        Widget widget = WidgetBuilder.aWidget().withId("my-widget").custom().build();
        Asset asset = AssetBuilder.anAsset().build();
        Mockito.when((Object)((Widget)this.widgetRepository.get("my-widget"))).thenReturn((Object)widget);
        Mockito.when((Object)this.widgetAssetService.save((Assetable)widget, asset)).thenThrow(IllegalArgumentException.class);
        ((DefaultWidgetService)Mockito.doReturn((Object)this.artifactStatusReport).when((Object)this.widgetService)).getStatus((Identifiable)((Widget)ArgumentMatchers.any()));
        Assertions.assertThatThrownBy(() -> this.widgetService.saveAsset("my-widget", asset)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void should_delete_an_asset() {
        Widget widget = WidgetBuilder.aWidget().withId("my-widget").custom().build();
        Mockito.when((Object)((Widget)this.widgetRepository.get("my-widget"))).thenReturn((Object)widget);
        ((DefaultWidgetService)Mockito.doReturn((Object)this.artifactStatusReport).when((Object)this.widgetService)).getStatus((Identifiable)((Widget)ArgumentMatchers.any()));
        this.widgetService.deleteAsset("my-widget", "UIID");
        ((AssetService)Mockito.verify(this.widgetAssetService)).delete((Assetable)widget, "UIID");
    }

    @Test
    void should_increment_an_asset() {
        Widget widget = WidgetBuilder.aWidget().withId("my-widget").custom().build();
        Mockito.when((Object)((Widget)this.widgetRepository.get("my-widget"))).thenReturn((Object)widget);
        ((DefaultWidgetService)Mockito.doReturn((Object)this.artifactStatusReport).when((Object)this.widgetService)).getStatus((Identifiable)((Widget)ArgumentMatchers.any()));
        this.widgetService.changeAssetOrder("my-widget", "UIID", AssetService.OrderType.INCREMENT);
        ((AssetService)Mockito.verify(this.widgetAssetService)).changeAssetOrderInComponent((Assetable)widget, "UIID", AssetService.OrderType.INCREMENT);
    }

    @Test
    void should_decrement_an_asset() {
        Widget widget = WidgetBuilder.aWidget().withId("my-widget").custom().build();
        Mockito.when((Object)((Widget)this.widgetRepository.get("my-widget"))).thenReturn((Object)widget);
        ((DefaultWidgetService)Mockito.doReturn((Object)this.artifactStatusReport).when((Object)this.widgetService)).getStatus((Identifiable)((Widget)ArgumentMatchers.any()));
        this.widgetService.changeAssetOrder("my-widget", "UIID", AssetService.OrderType.DECREMENT);
        ((AssetService)Mockito.verify(this.widgetAssetService)).changeAssetOrderInComponent((Assetable)widget, "UIID", AssetService.OrderType.DECREMENT);
    }

    @Test
    void should_mark_a_widget_as_favorite() {
        this.widgetService.markAsFavorite("my-widget", true);
        ((WidgetRepository)Mockito.verify((Object)this.widgetRepository)).markAsFavorite("my-widget");
    }

    @Test
    void should_unmark_a_widget_as_favorite() {
        this.widgetService.markAsFavorite("my-widget", false);
        ((WidgetRepository)Mockito.verify((Object)this.widgetRepository)).unmarkAsFavorite("my-widget");
    }

    @Test
    void should_load_widget_asset_on_disk() {
        this.widgetAssetService.findAssetPath("widget-id", "asset.js", AssetType.JAVASCRIPT.getPrefix());
        ((AssetService)Mockito.verify(this.widgetAssetService)).findAssetPath("widget-id", "asset.js", AssetType.JAVASCRIPT.getPrefix());
    }

    @Test
    void should_throw_IOException_when_widget_asset_included_in_page_produce_IOException() {
        Mockito.when((Object)this.widgetAssetService.findAssetPath("widget-id", "asset.js", AssetType.JAVASCRIPT.getPrefix())).thenThrow(new Throwable[]{new RuntimeException("can't read file")});
        String prefix = AssetType.JAVASCRIPT.getPrefix();
        Assertions.assertThatThrownBy(() -> this.widgetService.findAssetPath("widget-id", "asset.js", prefix)).isInstanceOf(RuntimeException.class);
    }

    @Test
    void should_serve_all_light_widgets_in_repository() {
        Widget input = WidgetBuilder.aWidget().withId("input").build();
        Widget label = WidgetBuilder.aWidget().withId("label").lastUpdate(Instant.parse("2015-02-02T00:00:00.000Z")).build();
        Mockito.when((Object)this.widgetRepository.getAll()).thenReturn(Arrays.asList(input, label));
        String[] ids = new String[]{"input", "label"};
        HashMap<String, List<Page>> map = new HashMap<String, List<Page>>();
        map.put("input", Collections.singletonList(PageBuilder.aPage().withName("hello").build()));
        Mockito.when((Object)this.pageRepository.getArtifactsUsingWidgets(Arrays.asList(ids))).thenReturn(map);
        Mockito.when((Object)this.pageRepository.getComponentName()).thenReturn((Object)"page");
        HashMap<String, List<Fragment>> map2 = new HashMap<String, List<Fragment>>();
        map2.put("label", Collections.singletonList(FragmentBuilder.aFragment().withName("helloFragment").build()));
        Mockito.when((Object)this.fragmentRepository.getArtifactsUsingWidgets(Arrays.asList(ids))).thenReturn(map2);
        Mockito.when((Object)this.fragmentRepository.getComponentName()).thenReturn((Object)"fragment");
        List<Widget> expectedWidgets = Arrays.asList(input, label);
        Mockito.when((Object)this.widgetRepository.getAll()).thenReturn(expectedWidgets);
        List returnedWidgets = this.widgetService.getAllWithUsedBy();
        ((ListAssert)((ListAssert)Assertions.assertThat((List)returnedWidgets).hasSameSizeAs(expectedWidgets)).contains((Object[])new Widget[]{input})).contains((Object[])new Widget[]{label});
        Assertions.assertThat((Map)input.getUsedBy()).hasSize(1);
        Assertions.assertThat((String)((Identifiable)((List)input.getUsedBy().get("page")).get(0)).getName()).isEqualTo("hello");
        Assertions.assertThat((Map)label.getUsedBy()).hasSize(1);
        Assertions.assertThat((String)((Identifiable)((List)label.getUsedBy().get("fragment")).get(0)).getName()).isEqualTo("helloFragment");
    }

    @Test
    void should_not_allow_to_delete_a_custom_widget_used_in_a_fragment() {
        Mockito.when((Object)((Widget)this.widgetRepository.get("customLabel"))).thenReturn((Object)WidgetBuilder.aWidget().custom().withId("customLabel").build());
        Mockito.when((Object)this.pageRepository.getArtifactsUsingWidget("customLabel")).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.fragmentRepository.getComponentName()).thenReturn((Object)"fragment");
        Mockito.when((Object)this.fragmentRepository.getArtifactsUsingWidget("customLabel")).thenReturn(Collections.singletonList(FragmentBuilder.aFragment().withName("person").build()));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.widgetService.delete("customLabel")).isInstanceOf(InUseException.class)).hasMessage("The widget cannot be deleted because it is used in 1 fragment, <person>");
    }

    @Test
    void should_fix_bonds_types_on_save() {
        Property constantTextProperty = PropertyBuilder.aProperty().name("text").bond(BondType.CONSTANT).build();
        Property interpolationTextProperty = PropertyBuilder.aProperty().name("text").bond(BondType.INTERPOLATION).build();
        Widget persistedWidget = WidgetBuilder.aWidget().withId("labelWidget").modelVersion(CURRENT_MODEL_VERSION).property(constantTextProperty).build();
        Mockito.lenient().when((Object)((Widget)this.widgetRepository.get("labelWidget"))).thenReturn((Object)persistedWidget);
        this.widgetService.updateProperty("labelWidget", "text", interpolationTextProperty);
        ((BondsTypesFixer)Mockito.verify(this.bondsTypesFixer)).fixBondsTypes("labelWidget", Collections.singletonList(interpolationTextProperty));
    }

    @Test
    void should_migrate_found_widget_when_get_is_called() {
        Mockito.reset((Object[])new DefaultWidgetService[]{this.widgetService});
        Widget widget = WidgetBuilder.aWidget().withId("widget").designerVersion("1.0.0").build();
        Widget widgetMigrated = WidgetBuilder.aWidget().withId("widget").modelVersion(CURRENT_MODEL_VERSION).previousArtifactVersion("1.0.0").build();
        Mockito.when((Object)((Widget)this.widgetRepository.get("widget"))).thenReturn((Object)widget);
        MigrationResult mr = new MigrationResult((Object)widgetMigrated, List.of(new MigrationStepReport(MigrationStatus.SUCCESS)));
        Mockito.when((Object)this.widgetMigrationApplyer.migrate(widget)).thenReturn((Object)mr);
        this.widgetService.get("widget");
        ((WidgetMigrationApplyer)Mockito.verify((Object)this.widgetMigrationApplyer)).migrate(widget);
        ((WidgetRepository)Mockito.verify((Object)this.widgetRepository)).updateLastUpdateAndSave((Identifiable)((Widget)mr.getArtifact()));
    }

    @Test
    void should_not_update_and_save_widget_if_no_migration_done() {
        Mockito.reset((Object[])new DefaultWidgetService[]{this.widgetService});
        Widget widget = WidgetBuilder.aWidget().withId("widget").modelVersion(CURRENT_MODEL_VERSION).build();
        Widget widgetMigrated = WidgetBuilder.aWidget().withId("widget").modelVersion(CURRENT_MODEL_VERSION).previousArtifactVersion(CURRENT_MODEL_VERSION).build();
        MigrationResult mr = new MigrationResult((Object)widget, Collections.singletonList((MigrationStepReport)ArgumentMatchers.any(MigrationStepReport.class)));
        Mockito.lenient().when((Object)this.widgetMigrationApplyer.migrate(widget)).thenReturn((Object)mr);
        Mockito.when((Object)((Widget)this.widgetRepository.get("widget"))).thenReturn((Object)widget);
        this.widgetService.get("widget");
        ((WidgetMigrationApplyer)Mockito.verify((Object)this.widgetMigrationApplyer, (VerificationMode)Mockito.never())).migrate(widget);
        ((WidgetRepository)Mockito.verify((Object)this.widgetRepository, (VerificationMode)Mockito.never())).updateLastUpdateAndSave((Identifiable)widgetMigrated);
    }

    @Test
    void should_migrate_all_custom_widget() throws Exception {
        Mockito.reset((Object[])new DefaultWidgetService[]{this.widgetService});
        Widget widget1 = WidgetBuilder.aWidget().withId("widget1").designerVersion("1.0.0").build();
        Widget widget2 = WidgetBuilder.aWidget().withId("widget2").designerVersion("1.0.0").build();
        Widget widget1Migrated = WidgetBuilder.aWidget().withId("widget1").designerVersion(CURRENT_MODEL_VERSION).build();
        Widget widget2Migrated = WidgetBuilder.aWidget().withId("widget2").designerVersion(CURRENT_MODEL_VERSION).build();
        Mockito.lenient().when((Object)((Widget)this.widgetRepository.get("widget1"))).thenReturn((Object)widget1);
        Mockito.lenient().when((Object)((Widget)this.widgetRepository.get("widget2"))).thenReturn((Object)widget2);
        Mockito.when((Object)this.widgetMigrationApplyer.migrate(widget1)).thenReturn((Object)new MigrationResult((Object)widget1Migrated, List.of(new MigrationStepReport(MigrationStatus.SUCCESS, "widget1"))));
        Mockito.when((Object)this.widgetMigrationApplyer.migrate(widget2)).thenReturn((Object)new MigrationResult((Object)widget2Migrated, List.of(new MigrationStepReport(MigrationStatus.SUCCESS, "widget2"))));
        HashSet<String> h = new HashSet<String>(Arrays.asList("widget1", "widget1"));
        Mockito.when((Object)this.widgetRepository.getByIds(h)).thenReturn(Arrays.asList(widget1, widget2));
        Page page = PageBuilder.aPage().with(new ElementBuilder[]{ComponentBuilder.aComponent((String)"widget1"), ComponentBuilder.aComponent((String)"widget2")}).build();
        Mockito.when((Object)this.widgetIdVisitor.visit((Previewable)page)).thenReturn(h);
        this.widgetService.migrateAllCustomWidgetUsedInPreviewable((Previewable)page);
        ((WidgetMigrationApplyer)Mockito.verify((Object)this.widgetMigrationApplyer)).migrate(widget1);
        ((WidgetMigrationApplyer)Mockito.verify((Object)this.widgetMigrationApplyer)).migrate(widget2);
    }

    @Test
    void should_not_update_and_save_widget_if_migration_finish_on_error() {
        Mockito.reset((Object[])new DefaultWidgetService[]{this.widgetService});
        Widget widget = WidgetBuilder.aWidget().withId("widget").modelVersion("1.0").build();
        Widget widgetMigrated = WidgetBuilder.aWidget().withId("widget").modelVersion(CURRENT_MODEL_VERSION).previousArtifactVersion(CURRENT_MODEL_VERSION).build();
        MigrationResult mr = new MigrationResult((Object)widget, List.of(new MigrationStepReport(MigrationStatus.ERROR)));
        Mockito.when((Object)this.widgetMigrationApplyer.migrate(widget)).thenReturn((Object)mr);
        Mockito.when((Object)((Widget)this.widgetRepository.get("widget"))).thenReturn((Object)widget);
        this.widgetService.get("widget");
        ((WidgetMigrationApplyer)Mockito.verify((Object)this.widgetMigrationApplyer)).migrate(widget);
        ((WidgetRepository)Mockito.verify((Object)this.widgetRepository, (VerificationMode)Mockito.never())).updateLastUpdateAndSave((Identifiable)widgetMigrated);
    }

    @Test
    void should_get_correct_migration_status_when_dependency_is_to_migrate() {
        Mockito.reset((Object[])new DefaultWidgetService[]{this.widgetService});
        Widget widget = WidgetBuilder.aWidget().withId("widget").designerVersion("1.10.0").build();
        Page page = PageBuilder.aPage().withId("myPage").withModelVersion(CURRENT_MODEL_VERSION).build();
        HashSet<String> ids = new HashSet<String>(List.of("widget"));
        Mockito.when((Object)this.widgetRepository.getByIds(ids)).thenReturn(Collections.singletonList(widget));
        Mockito.when((Object)this.widgetIdVisitor.visit((Previewable)page)).thenReturn(ids);
        ArtifactStatusReport status = this.widgetService.getArtifactStatusOfCustomWidgetUsed((Previewable)page);
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.getArtifactStatusReport(true, true), (Object)status.toString());
    }

    @Test
    void should_get_correct_migration_status_when_dependency_is_not_compatible() {
        Mockito.reset((Object[])new DefaultWidgetService[]{this.widgetService});
        Page page = PageBuilder.aPage().withId("myPage").withModelVersion(CURRENT_MODEL_VERSION).build();
        Widget widget1 = WidgetBuilder.aWidget().withId("widget1").designerVersion("1.10.0").build();
        Widget widget2 = WidgetBuilder.aWidget().withId("widget2").modelVersion("2.1").isCompatible(false).isMigration(false).build();
        HashSet<String> ids = new HashSet<String>(Arrays.asList("widget1", "widget2"));
        Mockito.when((Object)this.widgetRepository.getByIds(ids)).thenReturn(Arrays.asList(widget1, widget2));
        Mockito.when((Object)this.widgetIdVisitor.visit((Previewable)page)).thenReturn(ids);
        ArtifactStatusReport status = this.widgetService.getArtifactStatusOfCustomWidgetUsed((Previewable)page);
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.getArtifactStatusReport(false, false), (Object)status.toString());
    }

    @Test
    void should_get_correct_migration_status_when_dependency_is_not_to_migrate() {
        Mockito.reset((Object[])new DefaultWidgetService[]{this.widgetService});
        Widget widget = WidgetBuilder.aWidget().withId("widget").designerVersion(CURRENT_MODEL_VERSION).isCompatible(true).isMigration(false).build();
        Page page = PageBuilder.aPage().withId("myPage").withModelVersion(CURRENT_MODEL_VERSION).build();
        HashSet<String> ids = new HashSet<String>(List.of("widget"));
        Mockito.when((Object)this.widgetRepository.getByIds(ids)).thenReturn(Collections.singletonList(widget));
        Mockito.when((Object)this.widgetIdVisitor.visit((Previewable)page)).thenReturn(ids);
        ArtifactStatusReport status = this.widgetService.getArtifactStatusOfCustomWidgetUsed((Previewable)page);
        org.junit.jupiter.api.Assertions.assertEquals((Object)this.getArtifactStatusReport(true, false), (Object)status.toString());
    }

    private String getArtifactStatusReport(boolean compatible, boolean migration) {
        return new ArtifactStatusReport(compatible, migration).toString();
    }
}

