/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.workspace;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.workspace.CopyContentIfNotExistsVisitor;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class CopyContentIfNotExistsVisitorTest {
    @TempDir
    Path directory;
    Path source;
    Path destination;
    CopyContentIfNotExistsVisitor visitor;

    CopyContentIfNotExistsVisitorTest() {
    }

    @BeforeEach
    void setup() throws Exception {
        this.source = Files.createDirectory(this.directory.resolve("source"), new FileAttribute[0]);
        this.destination = Files.createDirectory(this.directory.resolve("destination"), new FileAttribute[0]);
        this.visitor = new CopyContentIfNotExistsVisitor(this.source, this.destination);
    }

    @Test
    void should_create_given_directory() throws Exception {
        this.visitor.preVisitDirectory(this.source.resolve("widgets"), null);
        Assertions.assertThat((boolean)Files.exists(this.destination.resolve("widgets"), new LinkOption[0])).isTrue();
    }

    @Test
    void should_not_create_given_directory_if_it_already_exist() throws Exception {
        Files.createDirectories(this.destination.resolve("widgets"), new FileAttribute[0]);
        this.visitor.preVisitDirectory(this.source.resolve("widgets"), null);
        Assertions.assertThat((boolean)Files.exists(this.destination.resolve("widgets"), new LinkOption[0])).isTrue();
    }

    @Test
    void should_copy_given_file_from_source_directory() throws Exception {
        Files.write(this.source.resolve("pbButton.json"), "contents".getBytes(), new OpenOption[0]);
        this.visitor.visitFile(this.source.resolve("pbButton.json"), null);
        Assertions.assertThat((byte[])Files.readAllBytes(this.destination.resolve("pbButton.json"))).isEqualTo((Object)"contents".getBytes());
    }

    @Test
    void should_not_copy_given_file_from_source_directory_if_it_already_exist() throws Exception {
        Files.write(this.source.resolve("pbButton.json"), "contents from source".getBytes(), new OpenOption[0]);
        Files.write(this.destination.resolve("pbButton.json"), "contents from destination".getBytes(), new OpenOption[0]);
        this.visitor.visitFile(this.source.resolve("pbButton.json"), null);
        Assertions.assertThat((byte[])Files.readAllBytes(this.destination.resolve("pbButton.json"))).isEqualTo((Object)"contents from destination".getBytes());
    }
}

