/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.bonitasoft.web.designer.ArtifactBuilderException;
import org.bonitasoft.web.designer.controller.asset.AssetService;
import org.bonitasoft.web.designer.migration.AbstractMigrationStep;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.asset.AssetType;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;
import org.bonitasoft.web.designer.model.page.Page;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StyleAssetMigrationStep
extends AbstractMigrationStep<Page> {
    private static final Logger logger = LoggerFactory.getLogger(StyleAssetMigrationStep.class);
    private final AssetService<Page> assetService;
    private final Path extractPath;

    public StyleAssetMigrationStep(Path extractPath, AssetService<Page> assetService) {
        this.assetService = assetService;
        this.extractPath = extractPath;
    }

    @Override
    public Optional<MigrationStepReport> migrate(Page artifact) {
        Asset style = new Asset().setName(this.getAssetName(artifact)).setType(AssetType.CSS);
        this.assetService.save(artifact, style, this.getContent());
        logger.info("[MIGRATION] Adding default CSS asset [{}] to {} [{}] (introduced in 1.4.8)", new Object[]{style.getName(), artifact.getType(), artifact.getName()});
        return Optional.empty();
    }

    private String getAssetName(Page artifact) {
        String name = "style%s.css";
        String suffix = "";
        while (artifact.hasAsset(AssetType.CSS, String.format(name, suffix))) {
            suffix = this.nextSuffix(suffix);
        }
        return String.format(name, suffix);
    }

    private String nextSuffix(String suffix) {
        return StringUtils.isBlank((CharSequence)suffix) ? "1" : String.valueOf(Integer.parseInt(suffix) + 1);
    }

    public byte[] getContent() {
        String defaultStyleFile = "templates/page/assets/css/style.css";
        try {
            return Files.readAllBytes(this.extractPath.resolve(defaultStyleFile));
        }
        catch (IOException e) {
            throw new ArtifactBuilderException("Missing " + defaultStyleFile + " from classpath", e);
        }
    }
}

