/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration.page;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import org.bonitasoft.web.designer.migration.AbstractMigrationStep;
import org.bonitasoft.web.designer.model.data.DataType;
import org.bonitasoft.web.designer.model.data.Variable;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;
import org.bonitasoft.web.designer.model.page.AbstractPage;

public class BusinessVariableMigrationStep<T extends AbstractPage>
extends AbstractMigrationStep<T> {
    private ObjectMapper mapper = new ObjectMapper();

    @Override
    public Optional<MigrationStepReport> migrate(AbstractPage page) throws IOException {
        for (Variable variable : page.getVariables().values()) {
            if (variable.getType() != DataType.BUSINESSDATA) continue;
            String property = (String)variable.getValue().get(0);
            JsonNode businessObjectNode = this.mapper.readTree(property);
            JsonNode idNode = businessObjectNode.get("id");
            String newId = idNode.asText().replace('_', '.');
            ((ObjectNode)businessObjectNode).put("id", newId);
            ((ObjectNode)businessObjectNode).remove("qualifiedName");
            JsonNode paginationNode = businessObjectNode.get("pagination");
            JsonNode pNode = paginationNode.get("p");
            ((ObjectNode)paginationNode).put("p", pNode.asText());
            JsonNode cNode = paginationNode.get("c");
            ((ObjectNode)paginationNode).put("c", cNode.asText());
            ArrayList<String> values = new ArrayList<String>();
            values.add(businessObjectNode.toString());
            variable.setValue(values);
        }
        return Optional.empty();
    }

    @Override
    public String getErrorMessage() {
        return "An error occurred during business variable migration";
    }
}

