/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.service;

import org.bonitasoft.web.designer.common.migration.Version;
import org.bonitasoft.web.designer.common.repository.Repository;
import org.bonitasoft.web.designer.config.UiDesignerProperties;
import org.bonitasoft.web.designer.model.ArtifactStatusReport;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.service.ArtifactService;

public abstract class AbstractArtifactService<R extends Repository<T>, T extends Identifiable>
implements ArtifactService<T> {
    protected UiDesignerProperties uiDesignerProperties;
    protected R repository;

    protected AbstractArtifactService(UiDesignerProperties uiDesignerProperties, R repository) {
        this.repository = repository;
        this.uiDesignerProperties = uiDesignerProperties;
    }

    @Override
    public void markAsFavorite(String id, boolean favorite) {
        if (favorite) {
            this.repository.markAsFavorite(id);
        } else {
            this.repository.unmarkAsFavorite(id);
        }
    }

    @Override
    public ArtifactStatusReport getStatus(T artifact) {
        return this.getArtifactStatus(artifact);
    }

    private ArtifactStatusReport getArtifactStatus(T artifact) {
        String artifactVersion = artifact.getArtifactVersion();
        if (artifactVersion == null) {
            return new ArtifactStatusReport(true, true);
        }
        Version modelVersion = new Version(this.uiDesignerProperties.getModelVersion());
        boolean migration = modelVersion.isGreaterThan(artifactVersion);
        boolean compatible = modelVersion.isGreaterOrEqualThan(artifactVersion);
        return new ArtifactStatusReport(compatible, migration);
    }

    public ArtifactStatusReport mergeStatusReport(ArtifactStatusReport artifactReport, ArtifactStatusReport dependenciesReport) {
        boolean isCompatible = artifactReport.isCompatible() && dependenciesReport.isCompatible();
        boolean needMigration = isCompatible && (artifactReport.isMigration() || dependenciesReport.isMigration());
        return new ArtifactStatusReport(isCompatible, needMigration);
    }

    @Override
    public ArtifactStatusReport getStatusWithoutDependencies(T artifact) {
        return this.getArtifactStatus(artifact);
    }
}

