/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.workspace;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public class CopyContentIfNotExistsVisitor
extends SimpleFileVisitor<Path> {
    private final Path targetDirectory;
    private final Path srcDirectory;

    public CopyContentIfNotExistsVisitor(Path srcDirectory, Path targetDirectory) {
        this.targetDirectory = targetDirectory;
        this.srcDirectory = srcDirectory;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        Path target = this.targetDirectory.resolve(this.srcDirectory.relativize(dir));
        if (!Files.exists(target, new LinkOption[0])) {
            Files.createDirectory(target, new FileAttribute[0]);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        Path target = this.targetDirectory.resolve(this.srcDirectory.relativize(file));
        if (!Files.exists(target, new LinkOption[0])) {
            Files.copy(file, target, new CopyOption[0]);
        }
        return FileVisitResult.CONTINUE;
    }
}

