/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.export.properties;

import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResourceURLFunction
implements Function<String, String> {
    private final Pattern pattern;
    private final String httpVerb;

    public ResourceURLFunction(String pattern) {
        this(pattern, "GET");
    }

    public ResourceURLFunction(String pattern, String httpVerb) {
        this.httpVerb = httpVerb;
        this.pattern = Pattern.compile(pattern);
    }

    @Override
    public String apply(String value) {
        Matcher api = this.pattern.matcher(value);
        return api.matches() ? this.httpVerb + "|" + api.group(1) + "/" + api.group(2) : "";
    }

    public String applyApi(String value) {
        Matcher api = this.pattern.matcher(value);
        return api.matches() ? api.group(1) + "/" + api.group(2) : "";
    }
}

