/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Date;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.zeroturnaround.zip.ZipException;
import org.zeroturnaround.zip.ZipUtil;

public class Unzipper {
    private final Path temporaryZipPath = Files.createTempDirectory("uid-tmp", new FileAttribute[0]);

    public Path unzipInTempDir(InputStream is, String tempDirPrefix) throws IOException {
        Path tempDirectory = Files.createTempDirectory(this.temporaryZipPath, tempDirPrefix, new FileAttribute[0]);
        Path zipFile = this.writeInDir(is, tempDirectory);
        try {
            ZipUtil.unpack((File)zipFile.toFile(), (File)tempDirectory.toFile());
        }
        catch (ZipException e) {
            throw new java.util.zip.ZipException(e.getMessage());
        }
        finally {
            FileUtils.deleteQuietly((File)zipFile.toFile());
        }
        return tempDirectory;
    }

    private Path writeInDir(InputStream is, Path tempDirectory) throws IOException {
        Path zipFile = tempDirectory.resolve("zipfile" + new Date().getTime());
        Files.write(zipFile, IOUtils.toByteArray((InputStream)is), new OpenOption[0]);
        return zipFile;
    }
}

