/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration;

import java.util.Optional;
import java.util.UUID;
import org.bonitasoft.web.designer.migration.AbstractMigrationStep;
import org.bonitasoft.web.designer.model.Assetable;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetIdMigrationStep<A extends Identifiable & Assetable>
extends AbstractMigrationStep<A> {
    private static final Logger logger = LoggerFactory.getLogger(AssetIdMigrationStep.class);

    @Override
    public Optional<MigrationStepReport> migrate(A artifact) {
        for (Asset asset : ((Assetable)artifact).getAssets()) {
            if (asset.getId() != null) continue;
            asset.setId(UUID.randomUUID().toString());
            logger.info("[MIGRATION] A uuid <{}> has been added to asset <{}> (Id was introduced in 1.0.2)", (Object)asset.getId(), (Object)asset.getName());
        }
        return Optional.empty();
    }
}

