/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration;

import java.util.Optional;
import org.bonitasoft.web.designer.migration.AbstractMigrationStep;
import org.bonitasoft.web.designer.model.data.DataType;
import org.bonitasoft.web.designer.model.data.Variable;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataExposedMigrationStep<T extends Fragment>
extends AbstractMigrationStep<T> {
    private static final Logger logger = LoggerFactory.getLogger(DataExposedMigrationStep.class);

    @Override
    public Optional<MigrationStepReport> migrate(T artifact) {
        artifact.getVariables().values().stream().filter(Variable::isExposed).forEach(variable -> {
            variable.setType(DataType.CONSTANT);
            variable.setDisplayValue("");
        });
        logger.info("[MIGRATION] Set type to constant for each exposed data into fragments [{}]", (Object)artifact.getName());
        return Optional.empty();
    }
}

