/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.migration.page;

import java.util.Optional;
import org.bonitasoft.web.designer.migration.AbstractMigrationStep;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;
import org.bonitasoft.web.designer.model.page.AbstractPage;
import org.bonitasoft.web.designer.model.page.Component;
import org.bonitasoft.web.designer.model.page.PropertyValue;
import org.bonitasoft.web.designer.model.widget.BondType;
import org.bonitasoft.web.designer.visitor.ComponentVisitor;
import org.bonitasoft.web.designer.visitor.ElementVisitor;

public class TextWidgetLabelMigrationStep<T extends AbstractPage>
extends AbstractMigrationStep<T> {
    private ComponentVisitor componentVisitor;

    public TextWidgetLabelMigrationStep(ComponentVisitor componentVisitor) {
        this.componentVisitor = componentVisitor;
    }

    @Override
    public Optional<MigrationStepReport> migrate(AbstractPage page) {
        for (Component component : (Iterable)page.accept((ElementVisitor)this.componentVisitor)) {
            if (!"pbText".equals(component.getId())) continue;
            this.updatePropertyValue(component, "labelHidden", BondType.CONSTANT, Boolean.TRUE);
            this.updatePropertyValue(component, "label", BondType.INTERPOLATION, "");
            this.updatePropertyValue(component, "labelPosition", BondType.CONSTANT, "top");
            this.updatePropertyValue(component, "labelWidth", BondType.CONSTANT, 4);
        }
        return Optional.empty();
    }

    @Override
    public String getErrorMessage() {
        return "An error occurred during add allowHtml property for Text Widget";
    }

    private void updatePropertyValue(Component component, String propertyName, BondType bondType, Object defaultValue) {
        if (!component.getPropertyValues().containsKey(propertyName)) {
            PropertyValue labelHiddenValue = new PropertyValue();
            labelHiddenValue.setType(bondType.toJson());
            labelHiddenValue.setValue(defaultValue);
            component.getPropertyValues().put(propertyName, labelHiddenValue);
        }
    }
}

