/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.service;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bonitasoft.web.designer.common.repository.FragmentRepository;
import org.bonitasoft.web.designer.common.repository.PageRepository;
import org.bonitasoft.web.designer.common.repository.WidgetContainerRepository;
import org.bonitasoft.web.designer.common.repository.WidgetRepository;
import org.bonitasoft.web.designer.common.repository.exception.InUseException;
import org.bonitasoft.web.designer.common.repository.exception.NotAllowedException;
import org.bonitasoft.web.designer.common.visitor.AssetVisitor;
import org.bonitasoft.web.designer.common.visitor.WidgetIdVisitor;
import org.bonitasoft.web.designer.config.UiDesignerProperties;
import org.bonitasoft.web.designer.controller.asset.AssetService;
import org.bonitasoft.web.designer.model.ArtifactStatusReport;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.migrationReport.MigrationResult;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStatus;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.model.widget.Property;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.service.AbstractAssetableArtifactService;
import org.bonitasoft.web.designer.service.BondsTypesFixer;
import org.bonitasoft.web.designer.service.WidgetMigrationApplyer;
import org.bonitasoft.web.designer.service.WidgetService;

public class DefaultWidgetService
extends AbstractAssetableArtifactService<WidgetRepository, Widget>
implements WidgetService {
    private final WidgetMigrationApplyer widgetMigrationApplyer;
    private final WidgetIdVisitor widgetIdVisitor;
    private final AssetVisitor assetVisitor;
    private final List<BondsTypesFixer> bondsTypesFixers;
    private final List<WidgetContainerRepository> widgetContainerRepositories;

    public DefaultWidgetService(WidgetRepository widgetRepository, PageRepository pageRepository, FragmentRepository fragmentRepository, List<BondsTypesFixer> bondsTypesFixers, WidgetMigrationApplyer widgetMigrationApplyer, WidgetIdVisitor widgetIdVisitor, AssetVisitor assetVisitor, UiDesignerProperties uiDesignerProperties, AssetService<Widget> widgetAssetService) {
        super(uiDesignerProperties, widgetAssetService, widgetRepository);
        this.bondsTypesFixers = bondsTypesFixers;
        this.widgetMigrationApplyer = widgetMigrationApplyer;
        this.widgetIdVisitor = widgetIdVisitor;
        this.assetVisitor = assetVisitor;
        this.widgetContainerRepositories = List.of(fragmentRepository, pageRepository);
    }

    @Override
    protected void checkUpdatable(String id) {
        super.checkUpdatable(id);
        if (id.startsWith("pb")) {
            throw new NotAllowedException("Not allowed to modify a non custom widgets");
        }
    }

    @Override
    public Widget create(Widget widget) {
        return ((WidgetRepository)this.repository).create(widget);
    }

    @Override
    public Widget createFrom(String sourceWidgetId, Widget widget) {
        Widget savedWidget = this.create(widget);
        Path widgetsPath = this.getWidgetsPath();
        Path sourceWidgetPath = ((WidgetRepository)this.repository).resolvePath(sourceWidgetId);
        this.assetService.duplicateAsset(widgetsPath, sourceWidgetPath, sourceWidgetId, savedWidget.getId());
        return savedWidget;
    }

    private Path getWidgetsPath() {
        return this.uiDesignerProperties.getWorkspace().getWidgets().getDir();
    }

    @Override
    public Widget save(String widgetId, Widget widget) {
        this.checkUpdatable(widgetId);
        if (!widget.isCustom()) {
            throw new NotAllowedException("We can only save a custom widget");
        }
        widget.setId(widgetId);
        return (Widget)((WidgetRepository)this.repository).updateLastUpdateAndSave((Identifiable)widget);
    }

    @Override
    public List<Property> addProperty(String widgetId, Property property) {
        this.checkUpdatable(widgetId);
        return ((WidgetRepository)this.repository).addProperty(widgetId, property);
    }

    @Override
    public List<Property> updateProperty(String widgetId, String propertyName, Property property) {
        this.checkUpdatable(widgetId);
        for (BondsTypesFixer bondsTypesFixer : this.bondsTypesFixers) {
            bondsTypesFixer.fixBondsTypes(widgetId, Collections.singletonList(property));
        }
        return ((WidgetRepository)this.repository).updateProperty(widgetId, propertyName, property);
    }

    @Override
    public List<Property> deleteProperty(String widgetId, String propertyName) {
        this.checkUpdatable(widgetId);
        return ((WidgetRepository)this.repository).deleteProperty(widgetId, propertyName);
    }

    @Override
    public Widget get(String id) {
        Widget widget = (Widget)((WidgetRepository)this.repository).get(id);
        return this.migrate(widget);
    }

    @Override
    public Widget getWithAsset(String id) {
        Widget widget = (Widget)((WidgetRepository)this.repository).get(id);
        widget = this.migrate(widget);
        widget.setAssets(this.assetVisitor.visit(widget));
        return widget;
    }

    @Override
    public List<Widget> getAll() {
        return ((WidgetRepository)this.repository).getAll().stream().map(widget -> {
            widget.setStatus(this.getStatus(widget));
            return widget;
        }).collect(Collectors.toList());
    }

    @Override
    public List<Widget> getAllWithUsedBy() {
        List<Widget> widgets = this.getAll();
        ArrayList<String> widgetIds = new ArrayList<String>();
        for (Widget widget : widgets) {
            widgetIds.add(widget.getId());
        }
        for (WidgetContainerRepository repository : this.widgetContainerRepositories) {
            Map map = repository.getArtifactsUsingWidgets(widgetIds);
            for (Widget widget : widgets) {
                widget.addUsedBy(repository.getComponentName(), (List)map.get(widget.getId()));
            }
        }
        return widgets;
    }

    @Override
    public void delete(String id) {
        Widget widget = (Widget)((WidgetRepository)this.repository).get(id);
        if (!widget.isCustom()) {
            throw new NotAllowedException("We can only delete a custom widget");
        }
        this.checkNotUsedByOther(widget);
        ((WidgetRepository)this.repository).delete(id);
    }

    private void checkNotUsedByOther(Widget widget) {
        StringBuilder message = new StringBuilder("The widget cannot be deleted because it is used in");
        for (WidgetContainerRepository repository : this.widgetContainerRepositories) {
            List componentsUsingWidget = repository.getArtifactsUsingWidget(widget.getId());
            if (componentsUsingWidget.isEmpty()) continue;
            int size = componentsUsingWidget.size();
            message.append(" ").append(size).append(" ").append(repository.getComponentName()).append(size > 1 ? "s" : "");
            componentsUsingWidget.forEach(component -> message.append(", <").append(component.getName()).append(">"));
            widget.addUsedBy(repository.getComponentName(), componentsUsingWidget);
        }
        if (widget.isUsed()) {
            throw new InUseException(message.toString());
        }
    }

    @Override
    public Widget migrate(Widget widget) {
        MigrationResult<Widget> migrationResult = this.migrateWithReport(widget);
        return (Widget)migrationResult.getArtifact();
    }

    @Override
    public MigrationResult<Widget> migrateWithReport(Widget widgetToMigrate) {
        widgetToMigrate.setStatus(this.getStatus(widgetToMigrate));
        if (!widgetToMigrate.getStatus().isMigration()) {
            return new MigrationResult((Object)widgetToMigrate, Collections.emptyList());
        }
        MigrationResult<Widget> migratedResult = this.widgetMigrationApplyer.migrate(widgetToMigrate);
        Widget migratedWidget = (Widget)migratedResult.getArtifact();
        if (!migratedResult.getFinalStatus().equals((Object)MigrationStatus.ERROR)) {
            ((WidgetRepository)this.repository).updateLastUpdateAndSave((Identifiable)migratedWidget);
        }
        return migratedResult;
    }

    @Override
    public List<MigrationStepReport> migrateAllCustomWidgetUsedInPreviewable(Previewable previewable) {
        ArrayList<MigrationStepReport> migrationStepReports = new ArrayList<MigrationStepReport>();
        ((WidgetRepository)this.repository).getByIds(this.widgetIdVisitor.visit(previewable)).forEach(w -> {
            MigrationResult<Widget> result = this.migrateWithReport((Widget)w);
            migrationStepReports.addAll(result.getMigrationStepReportListFilterByFinalStatus());
        });
        return migrationStepReports;
    }

    @Override
    public ArtifactStatusReport getArtifactStatusOfCustomWidgetUsed(Previewable previewable) {
        ArrayList reports = new ArrayList();
        ((WidgetRepository)this.repository).getByIds(this.widgetIdVisitor.visit(previewable)).forEach(widget -> reports.add(this.getStatus(widget)));
        boolean migration = false;
        for (ArtifactStatusReport report : reports) {
            if (!report.isCompatible()) {
                return report;
            }
            if (migration || !report.isMigration()) continue;
            migration = true;
        }
        return new ArtifactStatusReport(true, migration);
    }
}

