/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.export.properties;

import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.designer.config.UiDesignerProperties;
import org.bonitasoft.web.designer.controller.export.properties.FragmentPropertiesBuilder;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class FragmentPropertiesBuilderTest {
    private static final String DESIGNER_VERSION = "1.12.1";
    private FragmentPropertiesBuilder fragmentPropertiesBuilder;
    private Fragment fragment;

    FragmentPropertiesBuilderTest() {
    }

    @BeforeEach
    void setUp() {
        UiDesignerProperties uiDesignerProperties = new UiDesignerProperties();
        uiDesignerProperties.setVersion(DESIGNER_VERSION);
        this.fragmentPropertiesBuilder = new FragmentPropertiesBuilder(uiDesignerProperties);
        this.fragment = new Fragment();
        this.fragment.setName("myFragment");
    }

    @Test
    void should_build_a_well_formed_page_property_file() throws Exception {
        this.fragment.setDesignerVersion(DESIGNER_VERSION);
        byte[] a = this.fragmentPropertiesBuilder.build(this.fragment);
        String properties = new String(a);
        ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)properties).contains(new CharSequence[]{"contentType=fragment"})).contains(new CharSequence[]{"name=myFragment"})).contains(new CharSequence[]{"designerVersion=1.12.1"});
    }
}

