/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.importer;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.angularjs.GeneratorProperties;
import org.bonitasoft.web.designer.ArtifactBuilder;
import org.bonitasoft.web.designer.ArtifactBuilderFactory;
import org.bonitasoft.web.designer.UiDesignerCore;
import org.bonitasoft.web.designer.UiDesignerCoreFactory;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.builder.WidgetBuilder;
import org.bonitasoft.web.designer.common.livebuild.Watcher;
import org.bonitasoft.web.designer.common.repository.AssetRepository;
import org.bonitasoft.web.designer.common.repository.FragmentRepository;
import org.bonitasoft.web.designer.common.repository.PageRepository;
import org.bonitasoft.web.designer.common.repository.WidgetRepository;
import org.bonitasoft.web.designer.common.repository.exception.RepositoryException;
import org.bonitasoft.web.designer.config.UiDesignerProperties;
import org.bonitasoft.web.designer.controller.importer.ImportException;
import org.bonitasoft.web.designer.controller.importer.ServerImportException;
import org.bonitasoft.web.designer.controller.importer.mocks.PageImportMock;
import org.bonitasoft.web.designer.controller.importer.mocks.WidgetImportMock;
import org.bonitasoft.web.designer.controller.importer.report.ImportReport;
import org.bonitasoft.web.designer.model.ArtifactStatusReport;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.JsonHandler;
import org.bonitasoft.web.designer.model.JsonHandlerFactory;
import org.bonitasoft.web.designer.model.JsonViewPersistence;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.service.DefaultPageService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.internal.verification.VerificationModeFactory;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.LENIENT)
class ArtifactImporterTest {
    private static final String WIDGETS_FOLDER = "widgets";
    @Mock
    private PageRepository pageRepository;
    @Mock
    private DefaultPageService pageService;
    @Mock
    private WidgetRepository widgetRepository;
    @Spy
    private JsonHandler jsonHandler = new JsonHandlerFactory().create();
    private UiDesignerProperties uiDesignerProperties;
    private Path pageImportPath;
    private Path widgetImportPath;
    private Path pageUnzippedPath;
    private WidgetImportMock wMocks;
    private PageImportMock pMocks;
    private ArtifactBuilder artifactBuilder;

    ArtifactImporterTest() {
    }

    @BeforeEach
    void setUp(@TempDir Path tempDir) throws Exception {
        this.pageImportPath = Files.createTempDirectory(tempDir, "pageImport", new FileAttribute[0]);
        this.widgetImportPath = Files.createTempDirectory(tempDir, "widgetImport", new FileAttribute[0]);
        this.uiDesignerProperties = new UiDesignerProperties();
        this.uiDesignerProperties.getWorkspace().getPages().setDir(Files.createTempDirectory(tempDir, "pages", new FileAttribute[0]));
        this.uiDesignerProperties.getWorkspace().getWidgets().setDir(Files.createTempDirectory(tempDir, WIDGETS_FOLDER, new FileAttribute[0]));
        this.uiDesignerProperties.getWorkspace().getFragments().setDir(Files.createTempDirectory(tempDir, "fragments", new FileAttribute[0]));
        Mockito.when((Object)this.widgetRepository.getComponentName()).thenReturn((Object)"widget");
        Mockito.when((Object)this.widgetRepository.resolvePath((String)Mockito.any())).thenAnswer(invocation -> {
            String widgetId = (String)invocation.getArgument(0);
            return tempDir.resolve(WIDGETS_FOLDER).resolve(widgetId);
        });
        GeneratorProperties generatorProperties = new GeneratorProperties(tempDir);
        UiDesignerCore core = new UiDesignerCoreFactory(this.uiDesignerProperties, generatorProperties, this.jsonHandler).create((Watcher)Mockito.mock(Watcher.class), this.widgetRepository, (AssetRepository)Mockito.mock(AssetRepository.class), (FragmentRepository)Mockito.mock(FragmentRepository.class), this.pageRepository, (AssetRepository)Mockito.mock(AssetRepository.class));
        this.artifactBuilder = new ArtifactBuilderFactory(this.uiDesignerProperties, generatorProperties, this.jsonHandler, core).create();
        this.pageUnzippedPath = this.pageImportPath.resolve("resources");
        Files.createDirectory(this.pageUnzippedPath, new FileAttribute[0]);
        Mockito.when((Object)this.pageRepository.getComponentName()).thenReturn((Object)"page");
        Path widgetUnzippedPath = this.widgetImportPath.resolve("resources");
        Files.createDirectory(widgetUnzippedPath, new FileAttribute[0]);
        this.wMocks = new WidgetImportMock(this.pageUnzippedPath, this.widgetRepository);
        this.pMocks = new PageImportMock(this.pageRepository, this.jsonHandler);
    }

    @Test
    void should_import_artifact_located_on_disk() throws Exception {
        List<Widget> widgets = this.wMocks.mockWidgetsAsAddedDependencies();
        Page page = this.pMocks.mockPageToBeImported();
        Mockito.when((Object)((Page)this.pageRepository.updateLastUpdateAndSave((Identifiable)page))).thenReturn((Object)page);
        this.artifactBuilder.importPage(this.pageImportPath, true);
        ((WidgetRepository)Mockito.verify((Object)this.widgetRepository)).saveAll(widgets);
        ((PageRepository)Mockito.verify((Object)this.pageRepository, (VerificationMode)VerificationModeFactory.times((int)3))).updateLastUpdateAndSave((Identifiable)page);
    }

    @Test
    void should_prepare_widget_to_deserialize_on_import_widget() throws Exception {
        Widget widget = (Widget)Mockito.spy((Object)WidgetBuilder.aWidget().withId("aWidget").custom().build());
        ((JsonHandler)Mockito.doReturn((Object)widget).when((Object)this.jsonHandler)).fromJson((Path)Mockito.any(Path.class), (Class)Mockito.eq(Widget.class), (Class)Mockito.eq(JsonViewPersistence.class));
        Mockito.when((Object)((Widget)this.widgetRepository.updateLastUpdateAndSave((Identifiable)widget))).thenReturn((Object)widget);
        this.artifactBuilder.importWidget(this.widgetImportPath, true);
        ((Widget)Mockito.verify((Object)widget)).prepareWidgetToDeserialize((Path)Mockito.any(Path.class));
    }

    @Test
    void should_return_an_import_report_containing_imported_element_and_imported_dependencies() throws Exception {
        List<Widget> addedWidgets = this.wMocks.mockWidgetsAsAddedDependencies();
        List<Widget> overridenWidgets = this.wMocks.mockWidgetsAsOverridenDependencies();
        Page page = this.pMocks.mockPageToBeImported();
        Mockito.when((Object)((Page)this.pageRepository.updateLastUpdateAndSave((Identifiable)page))).thenReturn((Object)page);
        ImportReport report = this.artifactBuilder.importPage(this.pageImportPath, true);
        Assertions.assertThat((Map)report.getDependencies().getAdded()).containsEntry((Object)"widget", new ArrayList<Widget>(addedWidgets));
        Assertions.assertThat((Map)report.getDependencies().getOverwritten()).containsEntry((Object)"widget", new ArrayList<Widget>(overridenWidgets));
        Assertions.assertThat((Object)report.getElement()).isEqualTo((Object)page);
    }

    @Test
    void should_return_an_import_report_saying_that_page_is_going_to_be_overwritten_when_element_already_exists_in_repository() throws Exception {
        Page page = this.pMocks.mockPageToBeImported();
        Page existingPageInRepo = PageBuilder.aPage().withUUID(page.getUUID()).withName("alreadyHere").build();
        Mockito.when((Object)((Page)this.pageRepository.getByUUID(page.getUUID()))).thenReturn((Object)existingPageInRepo);
        Mockito.when((Object)((Page)this.pageRepository.get(existingPageInRepo.getId()))).thenReturn((Object)existingPageInRepo);
        ImportReport report = this.artifactBuilder.importPage(this.pageImportPath, true);
        Assertions.assertThat((Object)report.getElement()).isEqualTo((Object)page);
        Assertions.assertThat((Object)report.getOverwrittenElement()).isEqualTo((Object)existingPageInRepo);
        Assertions.assertThat((boolean)report.isOverwritten()).isTrue();
    }

    @Test
    void should_return_an_import_report_saying_that_widget_is_going_to_be_overwritten_when_element_already_exists_in_repository() throws Exception {
        Widget widget = WidgetBuilder.aWidget().withId("aWidget").custom().build();
        Widget existingWidgetInRepo = WidgetBuilder.aWidget().withId("aWidget").favorite().custom().build();
        Mockito.when((Object)this.widgetRepository.exists(widget.getId())).thenReturn((Object)true);
        Mockito.when((Object)((Widget)this.widgetRepository.get(widget.getId()))).thenReturn((Object)existingWidgetInRepo);
        ((JsonHandler)Mockito.doReturn((Object)existingWidgetInRepo).when((Object)this.jsonHandler)).fromJson((Path)Mockito.any(Path.class), (Class)Mockito.eq(Widget.class), (Class)Mockito.eq(JsonViewPersistence.class));
        Mockito.when((Object)((Widget)this.widgetRepository.updateLastUpdateAndSave((Identifiable)existingWidgetInRepo))).thenAnswer(invocationOnMock -> {
            Widget widgetArg = (Widget)invocationOnMock.getArgument(0);
            widgetArg.setLastUpdate(Instant.now());
            return widgetArg;
        });
        ImportReport report = this.artifactBuilder.importWidget(this.widgetImportPath, true);
        Assertions.assertThat((Object)report.getElement()).isEqualTo((Object)existingWidgetInRepo);
        Assertions.assertThat((boolean)report.isOverwritten()).isTrue();
    }

    @Test
    void should_return_an_import_report_saying_that_element_has_not_been_overwritten_when_element_does_not_exists_in_repository() throws Exception {
        Page page = this.pMocks.mockPageToBeImported();
        Mockito.when((Object)((Page)this.pageRepository.getByUUID(page.getUUID()))).thenReturn(null);
        ImportReport report = this.artifactBuilder.importPage(this.pageImportPath, true);
        Assertions.assertThat((Object)report.getElement()).isEqualTo((Object)page);
        Assertions.assertThat((boolean)report.isOverwritten()).isFalse();
        Assertions.assertThat((Object)report.getOverwrittenElement()).isNull();
    }

    @Test
    void should_return_an_import_report_saying_that_element_has_been_imported_when_there_are_no_conflict() throws Exception {
        List<Widget> widgets = this.wMocks.mockWidgetsAsAddedDependencies();
        Page page = this.pMocks.mockPageToBeImported();
        ImportReport report = this.artifactBuilder.importPage(this.pageImportPath, true);
        Assertions.assertThat((Comparable)report.getStatus()).isEqualTo((Object)ImportReport.Status.IMPORTED);
        ((WidgetRepository)Mockito.verify((Object)this.widgetRepository)).saveAll(widgets);
        ((PageRepository)Mockito.verify((Object)this.pageRepository, (VerificationMode)VerificationModeFactory.times((int)3))).updateLastUpdateAndSave((Identifiable)page);
    }

    @Test
    void should_return_an_import_report_saying_that_element_has_not_been_imported_when_there_are_conflict() throws Exception {
        List<Widget> overriddenWidgets = this.wMocks.mockWidgetsAsOverridenDependencies();
        Page page = this.pMocks.mockPageToBeImported();
        ImportReport report = this.artifactBuilder.importPage(this.pageImportPath, false);
        Assertions.assertThat((Comparable)report.getStatus()).isEqualTo((Object)ImportReport.Status.CONFLICT);
        ((WidgetRepository)Mockito.verify((Object)this.widgetRepository, (VerificationMode)Mockito.never())).saveAll(overriddenWidgets);
        ((PageRepository)Mockito.verify((Object)this.pageRepository, (VerificationMode)Mockito.never())).updateLastUpdateAndSave((Identifiable)page);
    }

    @Test
    void should_throw_import_exception_when_there_is_no_resource_folder_in_import_path(@TempDir Path tempDir) throws Exception {
        Path newFolder = Files.createDirectory(tempDir.resolve("emptyFolder"), new FileAttribute[0]);
        ImportException exception = (ImportException)org.junit.jupiter.api.Assertions.assertThrows(ImportException.class, () -> this.artifactBuilder.importPage(newFolder, true));
        Assertions.assertThat((Comparable)exception.getType()).isEqualTo((Object)ImportException.Type.UNEXPECTED_ZIP_STRUCTURE);
    }

    @Test
    void should_throw_server_import_exception_when_error_occurs_while_saving_files_in_repository() throws Exception {
        Page page = this.pMocks.mockPageToBeImported(PageBuilder.aPage().withId("aPage"));
        Mockito.when((Object)((Page)this.pageRepository.updateLastUpdateAndSave((Identifiable)page))).thenThrow(RepositoryException.class);
        org.junit.jupiter.api.Assertions.assertThrows(ServerImportException.class, () -> this.artifactBuilder.importPage(this.pageImportPath, true));
    }

    @Test
    void should_throw_import_exception_when_an_error_occurs_while_getting_widgets() throws Exception {
        Files.createDirectory(this.pageUnzippedPath.resolve(WIDGETS_FOLDER), new FileAttribute[0]);
        this.wMocks.mockWidgetsAsAddedDependencies();
        this.pMocks.mockPageToBeImported(PageBuilder.aPage().withId("aPage"));
        Mockito.when((Object)this.widgetRepository.loadAll(this.pageUnzippedPath.resolve(WIDGETS_FOLDER), WidgetRepository.CUSTOM_WIDGET_FILTER)).thenThrow(IOException.class);
        org.junit.jupiter.api.Assertions.assertThrows(ServerImportException.class, () -> this.artifactBuilder.importPage(this.pageImportPath, true));
    }

    @Test
    void should_force_an_import() throws Exception {
        List<Widget> addedWidgets = this.wMocks.mockWidgetsAsAddedDependencies();
        List<Widget> overriddenWidgets = this.wMocks.mockWidgetsAsOverridenDependencies();
        Page page = this.pMocks.mockPageToBeImported();
        Mockito.when((Object)this.pageRepository.exists(page.getId())).thenReturn((Object)false);
        ImportReport report = this.artifactBuilder.importPage(this.pageImportPath, true);
        Assertions.assertThat((Map)report.getDependencies().getAdded()).containsEntry((Object)"widget", new ArrayList<Widget>(addedWidgets));
        Assertions.assertThat((Map)report.getDependencies().getOverwritten()).containsEntry((Object)"widget", new ArrayList<Widget>(overriddenWidgets));
        Assertions.assertThat((Object)report.getElement()).isEqualTo((Object)page);
        Assertions.assertThat((String)report.getUUID()).isNotBlank();
        Assertions.assertThat((Comparable)UUID.fromString(report.getUUID())).isNotNull();
        Assertions.assertThat((Comparable)report.getStatus()).isEqualTo((Object)ImportReport.Status.IMPORTED);
        ((WidgetRepository)Mockito.verify((Object)this.widgetRepository, (VerificationMode)Mockito.never())).saveAll(overriddenWidgets);
        ((PageRepository)Mockito.verify((Object)this.pageRepository, (VerificationMode)VerificationModeFactory.times((int)3))).updateLastUpdateAndSave((Identifiable)((Page)Mockito.any(Page.class)));
    }

    @Test
    void should_force_an_import_overwriting_page() throws Exception {
        this.wMocks.mockWidgetsAsAddedDependencies();
        Page page = this.pMocks.mockPageToBeImported();
        Page existingPageInRepo = PageBuilder.aPage().withUUID(page.getUUID()).withId("alreadyHere").withName("alreadyHere").build();
        Mockito.when((Object)((Page)this.pageRepository.getByUUID(page.getUUID()))).thenReturn((Object)existingPageInRepo);
        Mockito.when((Object)((Page)this.pageRepository.get(existingPageInRepo.getId()))).thenReturn((Object)existingPageInRepo);
        Mockito.when((Object)this.pageRepository.exists(page.getId())).thenReturn((Object)false);
        ImportReport report = this.artifactBuilder.importPage(this.pageImportPath, true);
        Assertions.assertThat((Object)report.getOverwrittenElement()).isEqualTo((Object)existingPageInRepo);
        Assertions.assertThat((boolean)report.isOverwritten()).isTrue();
        Assertions.assertThat((Comparable)report.getStatus()).isEqualTo((Object)ImportReport.Status.IMPORTED);
        Assertions.assertThat((String)page.getId()).isEqualTo("id");
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).delete(existingPageInRepo.getId());
        ((PageRepository)Mockito.verify((Object)this.pageRepository, (VerificationMode)VerificationModeFactory.times((int)3))).updateLastUpdateAndSave((Identifiable)((Page)Mockito.any(Page.class)));
    }

    @Test
    void should_force_an_import_when_another_page_with_same_id_exist() throws Exception {
        this.wMocks.mockWidgetsAsAddedDependencies();
        Page page = this.pMocks.mockPageToBeImported();
        page.setName("myPage");
        Page existingPageInRepo = PageBuilder.aPage().withUUID(page.getUUID()).withId("alreadyHere").withName("alreadyHere").build();
        Mockito.when((Object)((Page)this.pageRepository.getByUUID(page.getUUID()))).thenReturn((Object)existingPageInRepo);
        Mockito.when((Object)((Page)this.pageRepository.get(existingPageInRepo.getId()))).thenReturn((Object)existingPageInRepo);
        Mockito.when((Object)this.pageRepository.exists(page.getId())).thenReturn((Object)true);
        Mockito.when((Object)this.pageRepository.getNextAvailableId(page.getName())).thenReturn((Object)"myPage1");
        ImportReport report = this.artifactBuilder.importPage(this.pageImportPath, true);
        Assertions.assertThat((Object)report.getOverwrittenElement()).isEqualTo((Object)existingPageInRepo);
        Assertions.assertThat((boolean)report.isOverwritten()).isTrue();
        Assertions.assertThat((Comparable)report.getStatus()).isEqualTo((Object)ImportReport.Status.IMPORTED);
        Assertions.assertThat((String)page.getId()).isEqualTo("myPage1");
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).delete(existingPageInRepo.getId());
        ((PageRepository)Mockito.verify((Object)this.pageRepository, (VerificationMode)VerificationModeFactory.times((int)3))).updateLastUpdateAndSave((Identifiable)((Page)Mockito.any(Page.class)));
    }

    @Test
    void should_return_incompatible_status_if_version_is_not_compatible_with_uid() throws Exception {
        this.uiDesignerProperties.setModelVersion("11.0.0");
        this.wMocks.mockWidgetsAsAddedDependencies();
        Page page = this.pMocks.mockPageToBeImported(PageBuilder.aPage().withName("myPage").withId("myPage").withModelVersion("12.0.0"));
        Mockito.lenient().when((Object)this.pageRepository.getNextAvailableId(page.getName())).thenReturn((Object)"myPage1");
        Mockito.when((Object)this.pageService.getStatusWithoutDependencies((Identifiable)page)).thenReturn((Object)new ArtifactStatusReport(false, false));
        ImportReport report = this.artifactBuilder.importPage(this.pageImportPath, true);
        Assertions.assertThat((Comparable)report.getStatus()).isEqualTo((Object)ImportReport.Status.INCOMPATIBLE);
        Assertions.assertThat((String)page.getId()).isEqualTo("myPage");
        ((PageRepository)Mockito.verify((Object)this.pageRepository, (VerificationMode)Mockito.never())).updateLastUpdateAndSave((Identifiable)((Page)Mockito.any(Page.class)));
    }
}

