/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.service;

import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.bonitasoft.web.designer.builder.AssetBuilder;
import org.bonitasoft.web.designer.builder.PageBuilder;
import org.bonitasoft.web.designer.builder.PageWithFragmentBuilder;
import org.bonitasoft.web.designer.common.repository.PageRepository;
import org.bonitasoft.web.designer.common.repository.exception.RepositoryException;
import org.bonitasoft.web.designer.common.visitor.AssetVisitor;
import org.bonitasoft.web.designer.config.UiDesignerProperties;
import org.bonitasoft.web.designer.controller.asset.AssetService;
import org.bonitasoft.web.designer.model.ArtifactStatusReport;
import org.bonitasoft.web.designer.model.Assetable;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.asset.Asset;
import org.bonitasoft.web.designer.model.asset.AssetType;
import org.bonitasoft.web.designer.model.data.DataType;
import org.bonitasoft.web.designer.model.data.Variable;
import org.bonitasoft.web.designer.model.exception.NotFoundException;
import org.bonitasoft.web.designer.model.migrationReport.MigrationResult;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStatus;
import org.bonitasoft.web.designer.model.migrationReport.MigrationStepReport;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.page.Previewable;
import org.bonitasoft.web.designer.service.DefaultPageService;
import org.bonitasoft.web.designer.service.PageMigrationApplyer;
import org.bonitasoft.web.designer.service.exception.IncompatibleException;
import org.bonitasoft.web.designer.visitor.ComponentVisitor;
import org.bonitasoft.web.designer.visitor.WebResourcesVisitor;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.junit.jupiter.MockitoSettings;
import org.mockito.quality.Strictness;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
@MockitoSettings(strictness=Strictness.LENIENT)
class PageServiceTest {
    private static final String CURRENT_MODEL_VERSION = "2.0";
    @Mock
    private PageMigrationApplyer pageMigrationApplyer;
    @Mock
    private PageRepository pageRepository;
    @Mock
    private ComponentVisitor componentVisitor;
    @Mock
    private AssetVisitor assetVisitor;
    @Mock
    private AssetService<Page> pageAssetService;
    private DefaultPageService pageService;
    @Mock
    private WebResourcesVisitor webResourcesVisitor;
    private ArtifactStatusReport defaultStatusReport;

    PageServiceTest() {
    }

    @BeforeEach
    void setUp() {
        this.pageService = (DefaultPageService)Mockito.spy((Object)new DefaultPageService(this.pageRepository, this.pageMigrationApplyer, this.componentVisitor, this.assetVisitor, new UiDesignerProperties("1.13.0", CURRENT_MODEL_VERSION), this.pageAssetService, this.webResourcesVisitor));
        this.defaultStatusReport = new ArtifactStatusReport(true, false);
        ((DefaultPageService)Mockito.doReturn((Object)this.defaultStatusReport).when((Object)this.pageService)).getStatus((Page)Mockito.any());
        Mockito.when((Object)((Page)this.pageRepository.updateLastUpdateAndSave((Identifiable)((Page)Mockito.any())))).thenAnswer(invocation -> invocation.getArgument(0));
    }

    @Test
    void should_migrate_found_page_when_get_is_called() {
        Page page = PageBuilder.aPage().withId("myPage").withDesignerVersion("1.0.0").build();
        Page migratedPage = PageBuilder.aPage().withId("myPage").withModelVersion(CURRENT_MODEL_VERSION).withPreviousArtifactVersion("1.0.0").build();
        Mockito.when((Object)((Page)this.pageRepository.get("myPage"))).thenReturn((Object)page);
        MigrationResult mr = new MigrationResult((Object)migratedPage, Arrays.asList(new MigrationStepReport(MigrationStatus.SUCCESS)));
        Mockito.when((Object)this.pageMigrationApplyer.migrate(page)).thenReturn((Object)mr);
        ((DefaultPageService)Mockito.doReturn((Object)new ArtifactStatusReport(true, true)).when((Object)this.pageService)).getStatus((Page)Mockito.any());
        this.pageService.get("myPage");
        ((PageMigrationApplyer)Mockito.verify((Object)this.pageMigrationApplyer)).migrate(page);
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)((Page)mr.getArtifact()));
    }

    @Test
    void should_not_update_and_save_page_if_no_migration_done() {
        Page page = PageBuilder.aPage().withId("myPage").withDesignerVersion(CURRENT_MODEL_VERSION).build();
        Mockito.when((Object)((Page)this.pageRepository.get("myPage"))).thenReturn((Object)page);
        Page returnedPage = this.pageService.get("myPage");
        ((PageMigrationApplyer)Mockito.verify((Object)this.pageMigrationApplyer, (VerificationMode)Mockito.never())).migrate(page);
        ((PageRepository)Mockito.verify((Object)this.pageRepository, (VerificationMode)Mockito.never())).updateLastUpdateAndSave((Identifiable)((Page)Mockito.any(Page.class)));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)returnedPage.getStatus().isCompatible());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)returnedPage.getStatus().isMigration());
    }

    @Test
    void should_not_update_and_save_page_if_migration_is_on_error() {
        Page page = PageBuilder.aPage().withId("myPage").withDesignerVersion("1.0.0").build();
        Page migratedPage = PageBuilder.aPage().withId("myPage").withModelVersion(CURRENT_MODEL_VERSION).withPreviousArtifactVersion("1.0.0").build();
        Mockito.when((Object)((Page)this.pageRepository.get("myPage"))).thenReturn((Object)page);
        MigrationResult mr = new MigrationResult((Object)migratedPage, Arrays.asList(new MigrationStepReport(MigrationStatus.ERROR)));
        Mockito.when((Object)this.pageMigrationApplyer.migrate(page)).thenReturn((Object)mr);
        ((DefaultPageService)Mockito.doReturn((Object)new ArtifactStatusReport(true, true)).when((Object)this.pageService)).getStatus((Page)Mockito.any());
        this.pageService.get("myPage");
        ((PageMigrationApplyer)Mockito.verify((Object)this.pageMigrationApplyer)).migrate(page);
        ((PageRepository)Mockito.verify((Object)this.pageRepository, (VerificationMode)Mockito.never())).updateLastUpdateAndSave((Identifiable)((Page)mr.getArtifact()));
    }

    @Test
    void should_migrate_page_when_dependencies_need_to_be_migrated() {
        Page page = PageBuilder.aPage().withId("myPage").withModelVersion(CURRENT_MODEL_VERSION).build();
        Page migratedPage = PageBuilder.aPage().withId("myPage").withModelVersion(CURRENT_MODEL_VERSION).withPreviousArtifactVersion("1.0.0").build();
        Mockito.when((Object)((Page)this.pageRepository.get("myPage"))).thenReturn((Object)page);
        MigrationResult mr = new MigrationResult((Object)migratedPage, Arrays.asList(new MigrationStepReport(MigrationStatus.SUCCESS)));
        Mockito.when((Object)this.pageMigrationApplyer.migrate(page)).thenReturn((Object)mr);
        ((DefaultPageService)Mockito.doReturn((Object)new ArtifactStatusReport(true, true)).when((Object)this.pageService)).getStatus((Page)Mockito.any());
        this.pageService.get("myPage");
        ((PageMigrationApplyer)Mockito.verify((Object)this.pageMigrationApplyer)).migrate(page);
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)((Page)mr.getArtifact()));
    }

    @Test
    void should_not_migrate_page_when_page_not_compatible() {
        Page page = PageBuilder.aPage().withId("myPage").withModelVersion("3.0").build();
        Mockito.when((Object)((Page)this.pageRepository.get("myPage"))).thenReturn((Object)page);
        this.pageService.get("myPage");
        ((PageMigrationApplyer)Mockito.verify((Object)this.pageMigrationApplyer, (VerificationMode)Mockito.never())).migrate(page);
        ((PageRepository)Mockito.verify((Object)this.pageRepository, (VerificationMode)Mockito.never())).updateLastUpdateAndSave((Identifiable)((Page)Mockito.any(Page.class)));
    }

    @Test
    void should_not_migrate_page_when_dependencies_not_compatible() {
        Page page = PageBuilder.aPage().withId("myPage").withModelVersion(CURRENT_MODEL_VERSION).build();
        Mockito.when((Object)((Page)this.pageRepository.get("myPage"))).thenReturn((Object)page);
        this.pageService.get("myPage");
        ((PageMigrationApplyer)Mockito.verify((Object)this.pageMigrationApplyer, (VerificationMode)Mockito.never())).migrate(page);
        ((PageRepository)Mockito.verify((Object)this.pageRepository, (VerificationMode)Mockito.never())).updateLastUpdateAndSave((Identifiable)((Page)Mockito.any(Page.class)));
    }

    @Test
    void should_migrate_page_when_no_artifact_version_is_declared() {
        Page page = PageBuilder.aPage().withId("myPage").build();
        Page migratedPage = PageBuilder.aPage().withId("myPage").withModelVersion(CURRENT_MODEL_VERSION).build();
        Mockito.when((Object)((Page)this.pageRepository.get("myPage"))).thenReturn((Object)page);
        MigrationResult mr = new MigrationResult((Object)migratedPage, Arrays.asList(new MigrationStepReport(MigrationStatus.SUCCESS)));
        Mockito.when((Object)this.pageMigrationApplyer.migrate(page)).thenReturn((Object)mr);
        ((DefaultPageService)Mockito.doReturn((Object)new ArtifactStatusReport(true, true)).when((Object)this.pageService)).getStatus((Page)Mockito.any());
        this.pageService.get("myPage");
        ((PageMigrationApplyer)Mockito.verify((Object)this.pageMigrationApplyer)).migrate(page);
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)((Page)Mockito.any(Page.class)));
    }

    private Asset aPageAsset() {
        return AssetBuilder.anAsset().withName("myJs.js").withType(AssetType.JAVASCRIPT).build();
    }

    private Asset aWidgetAsset() {
        return AssetBuilder.anAsset().withName("myCss.css").withType(AssetType.CSS).withScope("widget").withComponentId("widget-id").build();
    }

    private Page mockPageOfId(String id) {
        Page page = PageBuilder.aPage().withId(id).build();
        Mockito.when((Object)((Page)this.pageRepository.get(id))).thenReturn((Object)page);
        return page;
    }

    @Test
    void should_list_pages() throws Exception {
        Page page = new Page();
        String pageId = "id";
        page.setId("id");
        String pageName = "name";
        page.setName("name");
        Instant pageLastUpdate = Instant.parse("2015-02-02T00:00:00.000Z");
        page.setLastUpdate(pageLastUpdate);
        List<Page> pageList = Collections.singletonList(page);
        Mockito.when((Object)this.pageRepository.getAll()).thenReturn(pageList);
        List all = this.pageService.getAll();
        ((ListAssert)Assertions.assertThat((List)all).hasSize(pageList.size())).contains((Object[])new Page[]{page});
        Page firstPage = (Page)all.get(0);
        Assertions.assertThat((String)firstPage.getId()).isEqualTo("id");
        Assertions.assertThat((String)firstPage.getName()).isEqualTo("name");
        Assertions.assertThat((Instant)firstPage.getLastUpdate()).isEqualTo((Object)pageLastUpdate);
        Assertions.assertThat((Object)firstPage.getStatus()).isEqualTo((Object)this.defaultStatusReport);
    }

    @Test
    void should_create_a_page_from_a_Page() throws Exception {
        Page pageToBeSaved = PageBuilder.aPage().withId("my-page").build();
        List emptyRow = Collections.emptyList();
        List rows = Collections.singletonList(emptyRow);
        pageToBeSaved.setRows(rows);
        String name = "test";
        pageToBeSaved.setName("test");
        Mockito.when((Object)((Page)this.pageRepository.updateLastUpdateAndSave((Identifiable)pageToBeSaved))).thenReturn((Object)pageToBeSaved);
        Mockito.when((Object)this.pageRepository.getNextAvailableId("test")).thenReturn((Object)"test");
        Page savedPage = this.pageService.create(pageToBeSaved);
        Assertions.assertThat((String)savedPage.getId()).isEqualTo("test");
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)pageToBeSaved);
        ((AssetService)Mockito.verify(this.pageAssetService)).loadDefaultAssets((Assetable)pageToBeSaved);
    }

    @Test
    void should_duplicate_a_page_from_a_Page() {
        Asset pageAsset = this.aPageAsset();
        Asset widgetAsset = this.aWidgetAsset();
        String name = "test";
        Page pageToBeSaved = PageBuilder.aPage().withId("my-page").withName("test").withAsset(new Asset[]{pageAsset, widgetAsset}).build();
        String pageSourceId = "my-page-source";
        Mockito.when((Object)this.pageRepository.getNextAvailableId("test")).thenReturn((Object)"test");
        Page savedPage = this.pageService.createFrom("my-page-source", pageToBeSaved);
        Assertions.assertThat((String)savedPage.getId()).isEqualTo("test");
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)pageToBeSaved);
        Assertions.assertThat((String)savedPage.getName()).isEqualTo(pageToBeSaved.getName());
        Assertions.assertThat((Collection)savedPage.getAssets()).containsOnly((Object[])new Asset[]{pageAsset});
        ((AssetService)Mockito.verify(this.pageAssetService)).duplicateAsset((Path)Mockito.any(), (Path)Mockito.any(), (String)ArgumentMatchers.eq((Object)"my-page-source"), ArgumentMatchers.anyString());
    }

    @Test
    void should_save_a_page() {
        String pageId = "my-page";
        Page pageToBeSaved = this.mockPageOfId("my-page");
        Page savedPage = this.pageService.save("my-page", pageToBeSaved);
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)pageToBeSaved);
    }

    @Test
    void should_save_a_page_with_fragment() throws Exception {
        Page pageToBeSaved = PageWithFragmentBuilder.aPageWithFragmentElement();
        String name = pageToBeSaved.getName();
        pageToBeSaved.setId(name);
        Mockito.when((Object)((Page)this.pageRepository.get(name))).thenThrow(new Throwable[]{new org.bonitasoft.web.designer.common.repository.exception.NotFoundException()});
        Mockito.when((Object)this.pageRepository.getNextAvailableId(name)).thenReturn((Object)name);
        Page savedPage = this.pageService.save(pageToBeSaved.getId(), pageToBeSaved);
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)pageToBeSaved);
        Assertions.assertThat((List)savedPage.getRows()).isNotEmpty();
    }

    @Test
    void should_save_a_page_renaming_it() {
        String myPageName = "my-page";
        Page existingPage = PageBuilder.aPage().withId("my-page").withName("my-page").build();
        existingPage.addAsset(AssetBuilder.aFilledAsset((Page)existingPage));
        Mockito.when((Object)((Page)this.pageRepository.get("my-page"))).thenReturn((Object)existingPage);
        String newPageName = "page-new-name";
        Page pageToBeSaved = PageBuilder.aPage().withName("page-new-name").build();
        pageToBeSaved.addAsset(AssetBuilder.aFilledAsset((Page)existingPage));
        Mockito.when((Object)this.pageRepository.getNextAvailableId("page-new-name")).thenReturn((Object)"page-new-name");
        Page savedPage = this.pageService.save("my-page", pageToBeSaved);
        Assertions.assertThat((String)savedPage.getId()).isEqualTo("page-new-name");
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)PageBuilder.aPage().withId("page-new-name").withName("page-new-name").build());
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).delete("my-page");
        ((AssetService)Mockito.verify(this.pageAssetService)).duplicateAsset(this.pageRepository.resolvePath("my-page"), this.pageRepository.resolvePath("my-page"), "my-page", "page-new-name");
    }

    @Test
    void should_not_save_widget_assets_while_saving_a_page() {
        Page pageToBeSaved = PageBuilder.aPage().withId("my-page").withAsset(new Asset[]{this.aPageAsset()}).build();
        Mockito.when((Object)((Page)this.pageRepository.get("my-page"))).thenReturn((Object)pageToBeSaved);
        Page expectedPage = PageBuilder.aPage().withId("my-page").withAsset(new Asset[]{this.aPageAsset()}).build();
        Page savedPage = this.pageService.save(pageToBeSaved.getId(), pageToBeSaved);
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)expectedPage);
        ((AssetService)Mockito.verify(this.pageAssetService, (VerificationMode)Mockito.never())).duplicateAsset((Path)Mockito.any(), (Path)Mockito.any(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        Assertions.assertThat((Object)savedPage).isEqualTo((Object)expectedPage);
    }

    @Test
    void should_retrieve_a_page_representation_by_its_id() throws Exception {
        String pageId = "my-page";
        Page expectedPage = PageBuilder.aFilledPage((String)"my-page");
        expectedPage.setStatus(new ArtifactStatusReport(true, true));
        ((DefaultPageService)Mockito.doReturn((Object)new ArtifactStatusReport(false, false)).when((Object)this.pageService)).getStatus((Page)Mockito.any());
        Mockito.when((Object)((Page)this.pageRepository.get("my-page"))).thenReturn((Object)expectedPage);
        Page savedPage = this.pageService.get("my-page");
        Assertions.assertThat((Object)savedPage).isEqualTo((Object)expectedPage);
    }

    @Test
    void should_respond_ex_not_found_if_page_is_not_existing() throws Exception {
        String pageId = "my-page";
        Mockito.when((Object)((Page)this.pageRepository.get("my-page"))).thenThrow(new Throwable[]{new NotFoundException("page not found")});
        Assertions.assertThatThrownBy(() -> this.pageService.get("my-page")).isInstanceOf(NotFoundException.class);
    }

    @Test
    void should_respond_422_on_save_when_page_is_incompatible() {
        String pageId = "my-page";
        Page pageToBeSaved = this.mockPageOfId("my-page");
        ((DefaultPageService)Mockito.doReturn((Object)new ArtifactStatusReport(false, false)).when((Object)this.pageService)).getStatus((Page)Mockito.any());
        Mockito.when((Object)((Page)this.pageRepository.get("my-page"))).thenReturn((Object)pageToBeSaved);
        Assertions.assertThatThrownBy(() -> this.pageService.save("my-page", pageToBeSaved)).isInstanceOf(IncompatibleException.class);
        ((PageRepository)Mockito.verify((Object)this.pageRepository, (VerificationMode)Mockito.never())).updateLastUpdateAndSave((Identifiable)pageToBeSaved);
    }

    @Test
    void should_respond_404_not_found_when_delete_inexisting_page() throws Exception {
        String pageId = "my-page";
        ((PageRepository)Mockito.doThrow((Throwable[])new Throwable[]{new NotFoundException("page not found")}).when((Object)this.pageRepository)).delete("my-page");
        Assertions.assertThatThrownBy(() -> this.pageService.delete("my-page")).isInstanceOf(NotFoundException.class);
    }

    @Test
    void should_rename_a_page() throws Exception {
        String newName = "my-page-new-name";
        String pageId = "my-page";
        Page pageToBeUpdated = PageBuilder.aPage().withId("my-page").withName("page-name").build();
        Mockito.when((Object)((Page)this.pageRepository.get("my-page"))).thenReturn((Object)pageToBeUpdated);
        Mockito.when((Object)this.pageRepository.getNextAvailableId(newName)).thenReturn((Object)newName);
        Page savedPage = this.pageService.rename("my-page", newName);
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).getNextAvailableId(newName);
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).updateLastUpdateAndSave((Identifiable)pageToBeUpdated);
        Assertions.assertThat((String)pageToBeUpdated.getName()).isEqualTo(newName);
        Assertions.assertThat((String)pageToBeUpdated.getId()).isEqualTo(newName);
        Assertions.assertThat((String)savedPage.getId()).isEqualTo(newName);
    }

    @Test
    void should_not_rename_a_page_if_name_is_same() {
        String name = "page-name";
        String pageId = "my-page";
        Page pageToBeUpdated = PageBuilder.aPage().withId("my-page").withName(name).build();
        Mockito.when((Object)((Page)this.pageRepository.get("my-page"))).thenReturn((Object)pageToBeUpdated);
        Page page = this.pageService.rename("my-page", name);
        ((PageRepository)Mockito.verify((Object)this.pageRepository, (VerificationMode)Mockito.never())).updateLastUpdateAndSave((Identifiable)((Page)Mockito.any(Page.class)));
    }

    @Test
    void should_keep_assets_when_page_is_renamed() {
        String newName = "my-page-new-name";
        String pageId = "my-page";
        Page pageToBeUpdated = PageBuilder.aPage().withId("my-page").withName("page-name").build();
        pageToBeUpdated.addAsset(AssetBuilder.aFilledAsset((Page)pageToBeUpdated));
        Mockito.when((Object)((Page)this.pageRepository.get("my-page"))).thenReturn((Object)pageToBeUpdated);
        Mockito.when((Object)this.pageRepository.getNextAvailableId(newName)).thenReturn((Object)newName);
        Page page = this.pageService.rename("my-page", newName);
        ((AssetService)Mockito.verify(this.pageAssetService)).duplicateAsset(this.pageRepository.resolvePath("my-page"), this.pageRepository.resolvePath("my-page"), "my-page", newName);
        Assertions.assertThat((String)page.getName()).isEqualTo(newName);
        Assertions.assertThat((String)page.getId()).isEqualTo(newName);
        Assertions.assertThat((Collection)page.getAssets()).isNotEmpty();
    }

    @Test
    void should_respond_404_not_found_if_page_is_not_existing_when_renaming() throws Exception {
        String pageId = "my-page";
        Mockito.when((Object)((Page)this.pageRepository.get("my-page"))).thenThrow(new Throwable[]{new NotFoundException("page not found")});
        Assertions.assertThatThrownBy(() -> this.pageService.rename("my-page", "hello")).isInstanceOf(NotFoundException.class);
    }

    @Test
    void should_respond_500_internal_error_if_error_occurs_while_renaming_a_page() {
        String pageId = "my-page";
        Mockito.when((Object)((Page)this.pageRepository.get("my-page"))).thenReturn((Object)PageBuilder.aPage().withId("my-page").withName("my-page").build());
        Mockito.when((Object)((Page)this.pageRepository.updateLastUpdateAndSave((Identifiable)((Page)Mockito.any())))).thenThrow(new Throwable[]{new RepositoryException("exception occurs", (Throwable)new Exception())});
        Assertions.assertThatThrownBy(() -> this.pageService.rename("my-page", "hello")).isInstanceOf(RepositoryException.class);
    }

    @Test
    void should_upload_a_local_asset() throws Exception {
        String fileName = "myfile.js";
        byte[] fileContent = "foo".getBytes();
        String pageId = "my-page";
        Page page = this.mockPageOfId("my-page");
        Asset expectedAsset = AssetBuilder.anAsset().withId("assetId").active().withName("myfile.js").withOrder(2).withScope("page").withType(AssetType.JAVASCRIPT).build();
        Mockito.when((Object)this.pageAssetService.save((Assetable)((Page)ArgumentMatchers.eq((Object)page)), (Asset)Mockito.any(), (byte[])ArgumentMatchers.eq((Object)fileContent))).thenReturn((Object)expectedAsset);
        Asset asset = this.pageService.saveOrUpdateAsset("my-page", AssetType.JAVASCRIPT, "myfile.js", fileContent);
        Assertions.assertThat((Object)asset).isEqualTo((Object)expectedAsset);
    }

    @Test
    void should_save_an_external_asset() throws Exception {
        Page page = this.mockPageOfId("my-page");
        Asset expectedAsset = AssetBuilder.anAsset().withId("assetId").active().withName("myfile.js").withOrder(2).withScope("page").withType(AssetType.JAVASCRIPT).build();
        Mockito.when((Object)this.pageAssetService.save((Assetable)page, expectedAsset)).thenReturn((Object)expectedAsset);
        Asset asset = this.pageService.saveAsset(page.getId(), expectedAsset);
        Assertions.assertThat((Object)asset).isEqualTo((Object)expectedAsset);
        ((AssetService)Mockito.verify(this.pageAssetService)).save((Assetable)page, expectedAsset);
    }

    @Test
    void should_not_save_an_external_asset_when_upload_send_an_error() throws Exception {
        Page page = this.mockPageOfId("my-page");
        Asset asset = AssetBuilder.anAsset().build();
        ((AssetService)Mockito.doThrow(IllegalArgumentException.class).when(this.pageAssetService)).save((Assetable)page, asset);
        String id = page.getId();
        Assertions.assertThatThrownBy(() -> this.pageService.saveAsset(id, asset)).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void should_list_page_assets() throws Exception {
        Page page = this.mockPageOfId("my-page");
        Set<Asset> assets = Set.of(AssetBuilder.anAsset().withName("myCss.css").withType(AssetType.CSS).withScope("widget").withComponentId("widget-id").build(), AssetBuilder.anAsset().withName("myJs.js").withType(AssetType.JAVASCRIPT).withScope("page").build(), AssetBuilder.anAsset().withName("https://mycdn.com/myExternalJs.js").withScope("page").withType(AssetType.JAVASCRIPT).build());
        Mockito.when((Object)this.assetVisitor.visit((Previewable)page)).thenReturn(assets);
        Set pageAssets = this.pageService.listAsset(page);
        Assertions.assertThat((Collection)pageAssets).isEqualTo(assets);
    }

    @Test
    void should_list_page_assets_while_getting_a_page() throws Exception {
        Page page = this.mockPageOfId("my-page");
        Set<Asset> assets = Set.of(AssetBuilder.anAsset().withName("myCss.css").withType(AssetType.CSS).withScope("widget").withComponentId("widget-id").build(), AssetBuilder.anAsset().withName("myJs.js").withType(AssetType.JAVASCRIPT).withScope("page").build(), AssetBuilder.anAsset().withName("https://mycdn.com/myExternalJs.js").withScope("page").withType(AssetType.JAVASCRIPT).build());
        Mockito.when((Object)this.assetVisitor.visit((Previewable)page)).thenReturn(assets);
        Page pageAgain = this.pageService.getWithAsset(page.getId());
        Assertions.assertThat((Collection)pageAgain.getAssets()).isEqualTo(assets);
    }

    @Test
    void should_increment_an_asset() throws Exception {
        Page page = this.mockPageOfId("my-page");
        Asset asset = AssetBuilder.anAsset().withId("UIID").withComponentId("my-page").withOrder(3).build();
        this.pageService.changeAssetOrder(page.getId(), asset.getId(), AssetService.OrderType.INCREMENT);
        ((AssetService)Mockito.verify(this.pageAssetService)).changeAssetOrderInComponent((Assetable)page, asset.getId(), AssetService.OrderType.INCREMENT);
    }

    @Test
    void should_decrement_an_asset() throws Exception {
        Page page = this.mockPageOfId("my-page");
        Asset asset = AssetBuilder.anAsset().withId("UIID").withComponentId("my-page").withOrder(3).build();
        this.pageService.changeAssetOrder(page.getId(), asset.getId(), AssetService.OrderType.DECREMENT);
        ((AssetService)Mockito.verify(this.pageAssetService)).changeAssetOrderInComponent((Assetable)page, asset.getId(), AssetService.OrderType.DECREMENT);
    }

    @Test
    void should_delete_an_asset() throws Exception {
        String pageId = "my-page";
        String assetId = "UIID";
        Page page = this.mockPageOfId("my-page");
        this.pageService.deleteAsset("my-page", "UIID");
        ((AssetService)Mockito.verify(this.pageAssetService)).delete((Assetable)page, "UIID");
    }

    @Test
    void should_inactive_an_asset() throws Exception {
        Page page = this.mockPageOfId("my-page");
        this.pageService.changeAssetStateInPreviewable(page.getId(), "UIID", false);
        ((AssetService)Mockito.verify(this.pageAssetService)).changeAssetStateInPreviewable((Assetable)page, "UIID", false);
    }

    @Test
    void should_mark_a_page_as_favorite() throws Exception {
        this.pageService.markAsFavorite("my-page", true);
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).markAsFavorite("my-page");
    }

    @Test
    void should_unmark_a_page_as_favorite() throws Exception {
        this.pageService.markAsFavorite("my-page", false);
        ((PageRepository)Mockito.verify((Object)this.pageRepository)).unmarkAsFavorite("my-page");
    }

    @Test
    void should_load_page_asset_on_disk_with_content_type_text() throws Exception {
        this.pageService.findAssetPath("id", "fileName", "js");
        ((AssetService)Mockito.verify(this.pageAssetService)).findAssetPath("id", "fileName", "js");
    }

    private Variable anApiVariable(String value) {
        return new Variable(DataType.URL, value);
    }

    private Page setUpPageForResourcesTests() {
        Page page = this.mockPageOfId("myPage");
        Mockito.when((Object)this.componentVisitor.visit((Previewable)page)).thenReturn(Collections.emptyList());
        return page;
    }

    @Test
    void should_show_the_correct_information_for_variables() throws Exception {
        Path expectedFilePath = Paths.get(this.getClass().getResource("/page-with-variables/").toURI()).resolve("page-with-variables.json");
        String expectedFileString = String.join((CharSequence)"", Files.readAllLines(expectedFilePath));
        HashMap<String, Variable> variables = new HashMap<String, Variable>();
        variables.put("constantVar", new Variable(DataType.CONSTANT, "constantVariableValue"));
        variables.put("jsonVar", new Variable(DataType.JSON, "{\"var1\":1, \"var2\":2, \"var3\":\"value3\"}"));
        variables.put("jsVar", new Variable(DataType.EXPRESSION, "var variable = \"hello\"; return variable;"));
        Page page = new Page();
        page.setId("page-with-variables");
        page.setVariables(variables);
        page.setDesignerVersion("1.10.6");
        page.setName("page");
        page.setLastUpdate(Instant.ofEpochMilli(1514989634397L));
        page.setRows(new ArrayList());
        page.setStatus(new ArtifactStatusReport());
        Mockito.when((Object)((Page)this.pageRepository.get("id"))).thenReturn((Object)page);
        Page myPage = this.pageService.get("id");
        Assertions.assertThat((Map)myPage.getVariables()).isEqualTo(variables);
    }

    @Test
    void should_upload_newfile_and_save_new_asset() throws Exception {
        Page page = this.mockPageOfId("aPage");
        byte[] fileContent = "function(){}".getBytes();
        Asset expectedAsset = AssetBuilder.anAsset().withName("originalFileName.js").withType(AssetType.JAVASCRIPT).withOrder(1).build();
        Mockito.when((Object)this.pageAssetService.save((Assetable)((Page)ArgumentMatchers.eq((Object)page)), (Asset)Mockito.any(), (byte[])ArgumentMatchers.eq((Object)fileContent))).thenReturn((Object)expectedAsset);
        Asset asset = this.pageService.saveOrUpdateAsset(page.getId(), AssetType.JAVASCRIPT, "originalFileName.js", fileContent);
        ((AssetService)Mockito.verify(this.pageAssetService)).save((Assetable)page, asset, fileContent);
        Assertions.assertThat((Object)asset).isEqualTo((Object)expectedAsset);
    }

    @Test
    void should_upload_a_json_asset() throws Exception {
        Page page = this.mockPageOfId("page-id");
        byte[] fileContent = "{ \"some\": \"json\" }".getBytes();
        Asset expectedAsset = AssetBuilder.anAsset().withName("asset.json").withType(AssetType.JSON).withOrder(1).build();
        Mockito.when((Object)this.pageAssetService.save((Assetable)((Page)ArgumentMatchers.eq((Object)page)), (Asset)Mockito.any(), (byte[])ArgumentMatchers.eq((Object)fileContent))).thenReturn((Object)expectedAsset);
        Asset asset = this.pageService.saveOrUpdateAsset(page.getId(), AssetType.JSON, "asset.json", fileContent);
        ((AssetService)Mockito.verify(this.pageAssetService)).save((Assetable)page, asset, fileContent);
        Assertions.assertThat((Object)asset).isEqualTo((Object)expectedAsset);
    }

    @Test
    void should_return_error_when_uploading_with_error_onsave() throws Exception {
        Page page = this.mockPageOfId("id");
        String message = "Error while saving internal asset";
        Mockito.when((Object)this.pageAssetService.save((Assetable)((Page)Mockito.any()), (Asset)Mockito.any(), (byte[])Mockito.any())).thenThrow(new Throwable[]{new RepositoryException("Error while saving internal asset", (Throwable)new IllegalArgumentException())});
        Throwable exception = Assertions.catchThrowable(() -> this.pageService.saveOrUpdateAsset(page.getId(), AssetType.JAVASCRIPT, page.getId(), "0".getBytes(StandardCharsets.UTF_8)));
        Assertions.assertThat((Throwable)exception).isInstanceOf(RepositoryException.class);
        Assertions.assertThat((String)exception.getMessage()).isEqualTo("Error while saving internal asset");
    }

    @Test
    void should_upload_existing_file() throws Exception {
        Asset existingAsset = AssetBuilder.anAsset().withId("UIID").withName("asset.js").build();
        Page page = PageBuilder.aPage().withId("page-id").withName("my-page").withAsset(new Asset[]{existingAsset}).build();
        Mockito.when((Object)((Page)this.pageRepository.get(page.getId()))).thenReturn((Object)page);
        byte[] bytes = "function(){}".getBytes();
        Mockito.when((Object)this.pageAssetService.save((Assetable)((Page)ArgumentMatchers.eq((Object)page)), (Asset)Mockito.any(), (byte[])ArgumentMatchers.eq((Object)bytes))).thenReturn((Object)existingAsset);
        Asset asset = this.pageService.saveOrUpdateAsset(page.getId(), AssetType.JAVASCRIPT, "asset.js", bytes);
        ((AssetService)Mockito.verify(this.pageAssetService)).save((Assetable)page, (Asset)page.getAssets().iterator().next(), bytes);
        Assertions.assertThat((String)asset.getId()).isEqualTo(existingAsset.getId());
    }
}

