/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.workspace;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.assertj.core.api.Assertions;
import org.bonitasoft.web.angularjs.rendering.TemplateEngine;
import org.bonitasoft.web.angularjs.workspace.WidgetDirectiveBuilder;
import org.bonitasoft.web.designer.builder.WidgetBuilder;
import org.bonitasoft.web.designer.common.livebuild.PathListener;
import org.bonitasoft.web.designer.common.livebuild.Watcher;
import org.bonitasoft.web.designer.common.repository.JsonFileBasedLoader;
import org.bonitasoft.web.designer.common.repository.JsonFileBasedPersister;
import org.bonitasoft.web.designer.common.repository.WidgetFileBasedLoader;
import org.bonitasoft.web.designer.common.repository.WidgetFileBasedPersister;
import org.bonitasoft.web.designer.common.repository.WidgetRepository;
import org.bonitasoft.web.designer.model.Identifiable;
import org.bonitasoft.web.designer.model.JsonHandler;
import org.bonitasoft.web.designer.model.JsonHandlerFactory;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.repository.BeanValidator;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
class WidgetDirectiveBuilderTest {
    @TempDir
    Path widgetRepositoryDirectory;
    @Mock
    Watcher watcher;
    @Mock
    BeanValidator validator;
    WidgetDirectiveBuilder widgetDirectiveBuilder;
    Widget pbInput;
    Widget pbButton;
    TemplateEngine htmlBuilder = new TemplateEngine("widgetDirectiveTemplate.hbs.js");
    JsonHandler jsonHandler = new JsonHandlerFactory().create();

    WidgetDirectiveBuilderTest() {
    }

    @BeforeEach
    void setup() throws Exception {
        this.widgetDirectiveBuilder = new WidgetDirectiveBuilder(this.watcher, new WidgetFileBasedLoader(this.jsonHandler), true);
        WidgetFileBasedLoader widgetLoader = new WidgetFileBasedLoader(this.jsonHandler);
        WidgetRepository repository = new WidgetRepository(this.widgetRepositoryDirectory, this.widgetRepositoryDirectory, (JsonFileBasedPersister)new WidgetFileBasedPersister(this.jsonHandler, this.validator, "1.13.0", "2.0"), (JsonFileBasedLoader)widgetLoader, this.validator, (Watcher)Mockito.mock(Watcher.class));
        this.pbInput = WidgetBuilder.aWidget().withId("pbInput").build();
        this.pbInput.setCustom(true);
        Files.createDirectories(repository.resolvePath(this.pbInput.getId()), new FileAttribute[0]);
        repository.updateLastUpdateAndSave((Identifiable)this.pbInput);
        this.pbButton = WidgetBuilder.aWidget().withId("pbButton").build();
        this.pbButton.setCustom(true);
        Files.createDirectories(repository.resolvePath(this.pbButton.getId()), new FileAttribute[0]);
        repository.updateLastUpdateAndSave((Identifiable)this.pbButton);
    }

    @Test
    void should_build_directives_of_a_given_directory() throws Exception {
        this.widgetDirectiveBuilder.start(this.widgetRepositoryDirectory);
        Assertions.assertThat((String)this.readDirective("pbInput")).isEqualTo(this.generateDirective(this.pbInput));
        Assertions.assertThat((String)this.readDirective("pbButton")).isEqualTo(this.generateDirective(this.pbButton));
    }

    @Test
    void should_only_build_directives_files() throws Exception {
        Files.createFile(this.widgetRepositoryDirectory.resolve("whatever.txt"), new FileAttribute[0]);
        this.widgetDirectiveBuilder.start(this.widgetRepositoryDirectory);
        Assertions.assertThat((Object[])this.widgetRepositoryDirectory.toFile().list()).containsOnly((Object[])new String[]{".metadata", "pbButton", "whatever.txt", "pbInput"});
    }

    @Test
    void should_watch_given_directory_to_build_directives_on_change() throws Exception {
        this.widgetDirectiveBuilder.start(this.widgetRepositoryDirectory);
        ((Watcher)Mockito.verify((Object)this.watcher)).watch((Path)Mockito.eq((Object)this.widgetRepositoryDirectory), (PathListener)ArgumentMatchers.any(PathListener.class));
    }

    @Test
    void should_note_watch_given_directory_when_live_build_is_disabled() throws Exception {
        this.widgetDirectiveBuilder = new WidgetDirectiveBuilder(this.watcher, new WidgetFileBasedLoader(this.jsonHandler), false);
        this.widgetDirectiveBuilder.start(this.widgetRepositoryDirectory);
        ((Watcher)Mockito.verify((Object)this.watcher, (VerificationMode)Mockito.never())).watch((Path)Mockito.eq((Object)this.widgetRepositoryDirectory), (PathListener)ArgumentMatchers.any(PathListener.class));
    }

    @Test
    void should_build_directive_even_if_it_already_exist() throws Exception {
        this.writeDirective("pbInput", "previous content".getBytes());
        this.widgetDirectiveBuilder.build(this.resolve("pbInput/pbInput.json"));
        Assertions.assertThat((String)this.readDirective("pbInput")).isEqualTo(this.generateDirective(this.pbInput));
    }

    @Test
    void should_exclude_metadata_from_the_build() throws Exception {
        boolean isBuildable = this.widgetDirectiveBuilder.isBuildable(".metadata/123.json");
        Assertions.assertThat((boolean)isBuildable).isFalse();
    }

    private String readDirective(String widgetId) throws IOException {
        return new String(Files.readAllBytes(this.getDirectivePath(widgetId)));
    }

    private Path getDirectivePath(String widgetId) {
        return this.resolve(widgetId + "/" + widgetId + ".js");
    }

    private String generateDirective(Widget widget) throws IOException {
        return this.htmlBuilder.with("escapedTemplate", (Object)widget.getTemplate()).build((Object)widget);
    }

    private void writeDirective(String widgetId, byte[] contents) throws IOException {
        Files.write(this.resolve(widgetId + "/" + widgetId + ".js"), contents, new OpenOption[0]);
    }

    private Path resolve(String path) {
        return this.widgetRepositoryDirectory.resolve(path);
    }
}

