/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer;

import java.io.IOException;
import java.nio.file.Path;
import javax.validation.constraints.NotNull;
import org.bonitasoft.web.designer.common.generator.rendering.GenerationException;
import org.bonitasoft.web.designer.common.repository.exception.NotFoundException;
import org.bonitasoft.web.designer.controller.export.ExportException;
import org.bonitasoft.web.designer.controller.importer.report.ImportReport;
import org.bonitasoft.web.designer.model.ArtifactStatusReport;
import org.bonitasoft.web.designer.model.ModelException;
import org.bonitasoft.web.designer.model.fragment.Fragment;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.model.widget.Widget;
import org.bonitasoft.web.designer.workspace.Workspace;

public interface ArtifactBuilder {
    public Workspace getWorkspace();

    public byte[] buildPage(String var1) throws ModelException, ExportException, IOException;

    public byte[] build(Page var1) throws ModelException, ExportException, IOException;

    public byte[] buildFragment(String var1) throws ModelException, ExportException, IOException;

    public byte[] build(Fragment var1) throws ModelException, ExportException, IOException;

    public byte[] buildWidget(String var1) throws ModelException, ExportException, IOException;

    public byte[] build(Widget var1) throws ModelException, ExportException, IOException;

    public String buildHtml(Page var1, String var2) throws GenerationException, NotFoundException;

    public String buildHtml(Fragment var1, String var2) throws GenerationException, NotFoundException;

    public ImportReport importArtifact(Path var1, boolean var2);

    public ImportReport importPage(Path var1, boolean var2);

    public ImportReport importFragment(Path var1, boolean var2);

    public ImportReport importWidget(Path var1, boolean var2);

    public ImportReport replayImportIgnoringConflicts(String var1);

    public void cancelImport(String var1);

    public ArtifactStatusReport getPageStatus(@NotNull String var1);

    public ArtifactStatusReport getPageStatus(@NotNull Page var1);

    public ArtifactStatusReport getFragmentStatus(@NotNull String var1);

    public ArtifactStatusReport getFragmentStatus(@NotNull Fragment var1);

    public ArtifactStatusReport getWidgetStatus(@NotNull String var1);

    public ArtifactStatusReport getWidgetStatus(@NotNull Widget var1);
}

