/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.export.properties;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.bonitasoft.web.designer.common.generator.rendering.GenerationException;
import org.bonitasoft.web.designer.config.UiDesignerProperties;
import org.bonitasoft.web.designer.model.page.Page;
import org.bonitasoft.web.designer.service.PageService;

public class PagePropertiesBuilder {
    private final UiDesignerProperties uiDesignerProperties;
    private final PageService pageService;

    public byte[] build(Page page) throws GenerationException, IOException {
        List<String> resources = this.pageService.getResources(page);
        Properties properties = new Properties();
        properties.put("name", "custompage_" + page.getName());
        properties.put("contentType", String.valueOf(page.getType()).toLowerCase(Locale.ENGLISH));
        properties.put("displayName", StringUtils.isBlank((CharSequence)page.getDisplayName()) ? page.getName() : page.getDisplayName());
        properties.put("description", page.getDescription());
        properties.put("resources", resources.toString());
        properties.put("designerVersion", this.uiDesignerProperties.getVersion());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        properties.store(byteArrayOutputStream, "Generated by Bonita UI Designer");
        return byteArrayOutputStream.toByteArray();
    }

    public PagePropertiesBuilder(UiDesignerProperties uiDesignerProperties, PageService pageService) {
        this.uiDesignerProperties = uiDesignerProperties;
        this.pageService = pageService;
    }
}

