/*
 * Decompiled with CFR 0.152.
 */
package org.bonitasoft.web.designer.controller.export.properties;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import org.bonitasoft.web.designer.common.generator.rendering.GenerationException;
import org.bonitasoft.web.designer.config.UiDesignerProperties;
import org.bonitasoft.web.designer.model.widget.Widget;

public class WidgetPropertiesBuilder {
    private final UiDesignerProperties uiDesignerProperties;

    public WidgetPropertiesBuilder(UiDesignerProperties uiDesignerProperties) {
        this.uiDesignerProperties = uiDesignerProperties;
    }

    public byte[] build(Widget widget) throws GenerationException, IOException {
        Properties properties = new Properties();
        properties.put("name", widget.getName());
        properties.put("contentType", String.valueOf(widget.getType()).toLowerCase(Locale.ENGLISH));
        properties.put("designerVersion", this.uiDesignerProperties.getVersion());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        properties.store(byteArrayOutputStream, "Generated by Bonita UI Designer");
        return byteArrayOutputStream.toByteArray();
    }
}

